% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosticPlot.R
\name{diagnostic_plot}
\alias{diagnostic_plot}
\title{Quantile residual diagnostic plot for a GMVAR model}
\usage{
diagnostic_plot(
  gmvar,
  type = c("all", "series", "ac", "ch", "norm"),
  maxlag = 12,
  wait_time = 4
)
}
\arguments{
\item{gmvar}{an object of class \code{'gmvar'} created with \code{fitGMVAR} or \code{GMVAR}.}

\item{type}{which type of diagnostic plot should be plotted?
\itemize{
  \item{\code{"all"} all below sequentially.}
  \item{\code{"series"} the quantile residual time series.}
  \item{\code{"ac"} the quantile residual autocorrelation and cross-correlation functions.}
  \item{\code{"ch"} the squared quantile residual autocorrelation and cross-correlation functions.}
  \item{\code{"norm"} the quantile residual histogram with theoretical standard normal
    density (dashed line) and standard normal QQ-plots.}
}}

\item{maxlag}{the maximum lag considered in types \code{"ac"} and \code{"ch"}.}

\item{wait_time}{if \code{type == all} how many seconds to wait before showing next figure?}
}
\description{
\code{diagnostic_plot} plots a multivariate quantile residual diagnostic plot
  for either autocorrelation, conditional heteroskedasticity, or normality, or simply draws
  the quantile residual time series.
}
\details{
Auto- and cross-correlations (types \code{"ac"} and \code{"ch"}) are calculated with the function
 \code{acf} from the package \code{stats} and the plot method for class \code{'acf'} objects is employed.
}
\examples{
# GMVAR(1,2), d=2 model:
params12 <- c(0.55, 0.112, 0.344, 0.055, -0.009, 0.718, 0.319,
 0.005, 0.03, 0.619, 0.173, 0.255, 0.017, -0.136, 0.858, 1.185,
 -0.012, 0.136, 0.674)
mod12 <- GMVAR(gdpdef, p=1, M=2, params=params12)
diagnostic_plot(mod12, type="series")
diagnostic_plot(mod12, type="ac")

# GMVAR(2,2), d=2 model:
params22 <-  c(0.36, 0.121, 0.223, 0.059, -0.151, 0.395, 0.406,
 -0.005, 0.083, 0.299, 0.215, 0.002, 0.03, 0.484, 0.072, 0.218,
 0.02, -0.119, 0.722, 0.093, 0.032, 0.044, 0.191, 1.101, -0.004,
  0.105, 0.58)
mod22 <- GMVAR(gdpdef, p=2, M=2, params=params22)
diagnostic_plot(mod22, type="ch")
diagnostic_plot(mod22, type="norm")

# GMVAR(2,2), d=2 model with AR-parameters restricted to be
# the same for both regimes:
C_mat <- rbind(diag(2*2^2), diag(2*2^2))
params22c <- c(0.418, 0.153, 0.513, 0.057, 0.204, 0.028, -0.169,
 0.591, 0.241, 0.014, 0.091, 0.248, 1.068, -0.01, 0.111, 0.219,
 0.004, 0.027, 0.501)
mod22c <- GMVAR(gdpdef, p=2, M=2, params=params22c, constraints=C_mat)
diagnostic_plot(mod22c, wait_time=0.2)
diagnostic_plot(mod22c, type="ac", maxlag=12)
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Kalliovirta L. and Saikkonen P. 2010. Reliable Residuals for Multivariate Nonlinear
         Time Series Models. \emph{Unpublished Revision of HECER Discussion Paper No. 247}.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
 }
}
\seealso{
\code{\link{profile_logliks}}, \code{\link{fitGMVAR}}, \code{\link{GMVAR}}, \code{\link{quantile_residual_tests}},
 \code{\link{LR_test}}, \code{\link{Wald_test}}, \code{\link{cond_moment_plot}}, \code{\link[stats]{acf}},
  \code{\link[stats]{density}}, \code{\link{predict.gmvar}}
}
