% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSMVARconstruction.R
\name{gsmvar_to_sgsmvar}
\alias{gsmvar_to_sgsmvar}
\title{Switch from two-regime reduced form GMVAR, StMVAR, or G-StMVAR model to a structural model.}
\usage{
gsmvar_to_sgsmvar(gsmvar, calc_std_errors = TRUE, cholesky = FALSE)
}
\arguments{
\item{gsmvar}{an object of class \code{'gsmvar'}, typically created with \code{fitGSMVAR} or \code{GSMVAR}.}

\item{calc_std_errors}{should approximate standard errors be calculated?}

\item{cholesky}{if \code{M == 1}, should the lower triangular Cholesky identification be employed?
See details for using Cholesky identification with \code{M > 1}.}
}
\value{
Returns an object of class \code{'gsmvar'} defining a structural GMVAR, StMVAR, or G-StMVAR model based on a
  two-regime reduced form GMVAR, StMVAR, or G-StMVAR model, with the main diagonal of the B-matrix normalized to be
  positive.
}
\description{
\code{gsmvar_to_sgsmvar} constructs SGMVAR, SStMVAR, or SG-StMVAR model based on a reduced
  form GMVAR, StMVAR, or G-StMVAR model.
}
\details{
The switch is made by simultaneously diagonalizing the two error term covariance matrices
  with a well known matrix decomposition (Muirhead, 1982, Theorem A9.9) and then normalizing the
  diagonal of the matrix W positive (which implies positive diagonal of the B-matrix). Models with
  more that two regimes are not supported because the matrix decomposition does not generally
  exists for more than two covariance matrices. If the model has only one regime (= regular SVAR model),
  a symmetric and pos. def. square root matrix of the error term covariance matrix is used \strong{unless}
  \code{cholesky = TRUE} is set in the arguments, in which case Cholesky identification is employed.

  In order to employ a structural model with Cholesky identification and multiple regimes (\code{M > 1}),
  use the function \code{GIRF} directly with a reduced form model (see \code{?GIRF}).

  The columns of \eqn{W} as well as the lambda parameters can be re-ordered (without changing the implied
  reduced form model) afterwards with the function \code{reorder_W_columns}. Also all signs in any column
  of \eqn{W} can be swapped (without changing the implied reduced form model) afterwards with the function
  \code{swap_W_signs}. These two functions work with models containing any number of regimes.
}
\examples{
\donttest{
# Reduced form GMVAR(1,2) model
params12 <- c(0.55, 0.112, 0.344, 0.055, -0.009, 0.718, 0.319,
 0.005, 0.03, 0.619, 0.173, 0.255, 0.017, -0.136, 0.858, 1.185,
 -0.012, 0.136, 0.674)
mod12 <- GSMVAR(gdpdef, p=1, M=2, params=params12)

# Form a structural model based on the reduced form model:
mod12s <- gsmvar_to_sgsmvar(mod12)
mod12s

#' # Reduced form StMVAR(1,2) model
mod12t <- GSMVAR(gdpdef, p=1, M=2, params=c(params12, 11, 12), model="StMVAR")

# Form a structural model based on the reduced form model:
mod12ts <- gsmvar_to_sgsmvar(mod12t)
mod12ts
}
}
\references{
\itemize{
   \item Muirhead R.J. 1982. Aspects of Multivariate Statistical Theory, \emph{Wiley}.
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. 2022. Structural Gaussian mixture vector autoregressive model with application to the asymmetric
     effects of monetary policy shocks. Unpublished working paper, available as arXiv:2007.04713.
   \item Virolainen S. 2022. Gaussian and Student's t mixture vector autoregressive model with application to the
     asymmetric effects of monetary policy shocks in the Euro area. Unpublished working
     paper, available as arXiv:2109.13648.
 }
}
\seealso{
\code{\link{fitGSMVAR}}, \code{\link{GSMVAR}}, \code{\link{GIRF}}, \code{\link{reorder_W_columns}},
 \code{\link{swap_W_signs}}, \code{\link{stmvar_to_gstmvar}}
}
