% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictMethod.R
\name{predict.gsmvar}
\alias{predict.gsmvar}
\title{Predict method for class 'gsmvar' objects}
\usage{
\method{predict}{gsmvar}(
  object,
  ...,
  n_ahead,
  nsim = 2000,
  pi = c(0.95, 0.8),
  pi_type = c("two-sided", "upper", "lower", "none"),
  pred_type = c("median", "mean", "cond_mean"),
  plot_res = TRUE,
  mix_weights = TRUE,
  nt
)
}
\arguments{
\item{object}{an object of class \code{'gsmvar'}, typically created with \code{fitGSMVAR} or \code{GSMVAR}.}

\item{...}{additional arguments passed to \code{grid} (ignored if \code{plot_res==FALSE}) which plots
grid to the figure.}

\item{n_ahead}{how many steps ahead should be predicted?}

\item{nsim}{to how many independent simulations should the forecast be based on?}

\item{pi}{a numeric vector specifying the confidence levels of the prediction intervals.}

\item{pi_type}{should the prediction intervals be "two-sided", "upper", or "lower"?}

\item{pred_type}{should the prediction be based on sample "median" or "mean"? Or should it
be one-step-ahead forecast based on the exact conditional mean (\code{"cond_mean"})?
Prediction intervals won't be calculated if the exact conditional mean is used.}

\item{plot_res}{should the results be plotted?}

\item{mix_weights}{\code{TRUE} if forecasts for mixing weights should be plotted,
\code{FALSE} in not.}

\item{nt}{a positive integer specifying the number of observations to be plotted
along with the prediction (ignored if \code{plot_res==FALSE}). Default is \code{round(nrow(data)*0.15)}.}
}
\value{
Returns a class '\code{gsmvarpred}' object containing, among the specifications,...
 \describe{
   \item{$pred}{Point forecasts}
   \item{$pred_int}{Prediction intervals, as \code{[, , d]}.}
   \item{$mix_pred}{Point forecasts for the mixing weights}
   \item{mix_pred_int}{Individual prediction intervals for mixing weights, as \code{[, , m]}, m=1,..,M.}
 }
}
\description{
\code{predict.gsmvar} is a predict method for class \code{'gsmvar'} objects. The forecasts of
  the GMVAR, StMVAR, and G-StMVAR models are computed by performing independent simulations and using the
  sample medians or means as point forecasts and empirical quantiles as prediction intervals.
  For one-step-ahead predictions using the exact conditional mean is also supported.
}
\examples{
# GMVAR(2, 2), d=2 model
params22 <- c(0.36, 0.121, 0.223, 0.059, -0.151, 0.395, 0.406, -0.005,
 0.083, 0.299, 0.215, 0.002, 0.03, 0.484, 0.072, 0.218, 0.02, -0.119,
  0.722, 0.093, 0.032, 0.044, 0.191, 1.101, -0.004, 0.105, 0.58)
mod22 <- GSMVAR(gdpdef, p=2, M=2, d=2, params=params22)
p1 <- predict(mod22, n_ahead=10, pred_type="median", nsim=500)
p1
p2 <- predict(mod22, n_ahead=10, nt=20, lty=1, nsim=500)
p2
p3 <- predict(mod22, n_ahead=10, pi=c(0.99, 0.90, 0.80, 0.70),
              nt=30, lty=0, nsim=500)
p3

# StMVAR(2, 2), d=2 model
params22t <- c(0.36, 0.121, 0.223, 0.059, -0.151, 0.395, 0.406, -0.005,
 0.083, 0.299, 0.215, 0.002, 0.03, 0.484, 0.072, 0.218, 0.02, -0.119,
  0.722, 0.093, 0.032, 0.044, 0.191, 1.101, -0.004, 0.105, 0.58, 3, 4)
mod22t <- GSMVAR(gdpdef, p=2, M=2, d=2, params=params22t, model="StMVAR")
p1 <- predict(mod22t, n_ahead=12, pred_type="median", nsim=500, pi=0.9)
p1
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. (forthcoming). A statistically identified structural vector autoregression with endogenously
          switching volatility regime. \emph{Journal of Business & Economic Statistics}.
   \item Virolainen S. 2022. Gaussian and Student's t mixture vector autoregressive model with application to the
     asymmetric effects of monetary policy shocks in the Euro area. Unpublished working
     paper, available as arXiv:2109.13648.
 }
 @keywords internal
}
\seealso{
\code{\link{GIRF}}, \code{\link{GFEVD}}, \code{\link{simulate.gsmvar}}
}
