% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_model.R
\name{kappa_calc}
\alias{kappa_calc}
\title{Genetic correlation effects}
\usage{
kappa_calc(qt1, qt2, g, weight_scale = 1, bias_scale = 0)
}
\arguments{
\item{qt1}{A numeric vector.}

\item{qt2}{A numeric vector.}

\item{g}{An integer vector.}

\item{weight_scale}{Used to appropriately scale the weight assigned to the correlation estimators}

\item{bias_scale}{Used to appropriately scale the bias of the correlation estimators}
}
\value{
A list with the values:

* kappa, the estimated correlation effect
* pval, the p-value of the likelihood ratio test
}
\description{
This function estimates the correlation effect of a genetic variant on a pair of quantitative traits.
The effect (kappa) is measured on Fisher transformed correlation values.
The genotype is coded as 0 (non-carrier), 1 (single copy of effect allele) and 2 (two copies of effect allele).
We use a likelihood ratio test with 1 degree of freedom:
* H0: z_0 = z_1 = z_2,
* H1: z_j = z_null +kappa*j,
where z_j is the Fisher-transformed correlation between the traits amongst subjects of genotype j.

If the traits follow a joint normal distribution, then (thoretically) the Fisher-transformed sample correlation (z) is approximately normally distributed with mean 0 and
standard error 1/sqrt(n-3).
Otherwise, we have to correct for possible bias in the estimators and scale the weights we assign to them appropriately

Note, that even though each trait follows a normal distribution individually, that does not necessarily imply that the pair of them follow a joint normal distirbution.
}
\examples{
Sigma0 <- matrix(c(1,0,0,1),nrow=2,ncol=2)
Sigma1 <- matrix(c(1,0.3,0.3,1),nrow=2,ncol=2)
Sigma2 <- matrix(c(1,0.6,0.6,1),nrow=2,ncol=2)
geno_vec <- c(rep(0,10000),rep(1,1000),rep(2,100))
Q0 <- MASS::mvrnorm(n = 10000, mu = c(0,0), Sigma = Sigma0)
Q1 <- MASS::mvrnorm(n = 1000, mu = c(0,0), Sigma = Sigma1)
Q2 <- MASS::mvrnorm(n = 100, mu = c(0,0), Sigma = Sigma2)
Q <- rbind(Q0,Q1)
Q <- rbind(Q,Q2)
qt1_val <- Q[,1]
qt2_val <- Q[,2]
res <- kappa_calc(qt1_val, qt2_val, geno_vec)
}
