% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ga_v4_get.R
\name{fetch_google_analytics_4}
\alias{fetch_google_analytics_4}
\title{Fetch multiple GAv4 requests}
\usage{
fetch_google_analytics_4(request_list, merge = FALSE)
}
\arguments{
\item{request_list}{A list of requests created by \link{make_ga_4_req}}

\item{merge}{If TRUE then will rbind that list of data.frames}
}
\value{
A dataframe if one request, or a list of data.frames if multiple.
}
\description{
Fetch the GAv4 requests as created by \link{make_ga_4_req}
}
\details{
For same viewId, daterange, segments, samplingLevel and cohortGroup, v4 batches can be made
}
\examples{

\dontrun{
library(googleAnalyticsR)

## authenticate, 
## or use the RStudio Addin "Google API Auth" with analytics scopes set
ga_auth()

## get your accounts
account_list <- google_analytics_account_list()

## pick a profile with data to query

ga_id <- account_list[23,'viewId']

ga_req1 <- make_ga_4_req(ga_id, 
                         date_range = c("2015-07-30","2015-10-01"),
                         dimensions=c('source','medium'), 
                         metrics = c('sessions'))

ga_req2 <- make_ga_4_req(ga_id, 
                         date_range = c("2015-07-30","2015-10-01"),
                         dimensions=c('source','medium'), 
                         metrics = c('users'))
                         
fetch_google_analytics_4(list(ga_req1, ga_req2))

}

}
\seealso{
Other GAv4 fetch functions: \code{\link{google_analytics_4}},
  \code{\link{make_ga_4_req}}
}

