% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_data_source.R
\name{ga_custom_upload_file}
\alias{ga_custom_upload_file}
\title{Upload data to Google Analytics}
\usage{
ga_custom_upload_file(accountId, webPropertyId, customDataSourceId, upload)
}
\arguments{
\item{accountId}{Account Id}

\item{webPropertyId}{Web Property Id}

\item{customDataSourceId}{Custom data source Id}

\item{upload}{An R data.frame or a file path location (character)}
}
\value{
An object of class \code{ga_custom_data_source_upload}
}
\description{
Upload external data up to 1GB to Google Analytics via the management API.
}
\details{
You need to create a custom data source in the web UI first.  

If you are uploading an R data frame, the function will prefix the column names with \code{"ga:"} for you if necessary.
  
After upload check the status by querying data sources using \link{ga_custom_upload} 
  and examining the \code{status} field.

Currently only supports simple uploads (not resumable).
}
\examples{

\dontrun{

upload_me <- data.frame(medium = "shinyapps", 
                        source = "referral", 
                        adCost = 1, 
                        date = "20160801")
                        
obj <- ga_custom_upload_file(47850439, 
                             "UA-4748043-2", 
                             "_jDsJHSFSU-uw038Bh8fUg", 
                             upload_me)
                             
## obj will initially have status = PENDING
obj
==Google Analytics Custom Data Source Upload==
Custom Data Source ID:  _jDsJHSFSU-uw038Bh8fUg 
Account ID:             47850439 
Web Property Id:        UA-4748043-2 
Upload ID:              7yHLAkeLSiK1zveVTiWZwA 
Status:                 PENDING 

## Send obj to ga_custom_upload() to check and renew status
obj <- ga_custom_upload(upload_object = obj)
obj

==Google Analytics Custom Data Source Upload==
Custom Data Source ID:  _jDsJHSFSU-uw038Bh8fUg 
Account ID:             47850439 
Web Property Id:        UA-4748043-2 
Upload ID:              7yHLAkeLSiK1zveVTiWZwA 
Status:                 COMPLETED 

}


}
\seealso{
A guide for preparing the data is available: \href{https://developers.google.com/analytics/solutions/data-import-cost}{from Google here}.

The dev guide for this function: \href{https://developers.google.com/analytics/devguides/config/mgmt/v3/data-import#format}{Data Import Developer Guide}

Other custom datasource functions: \code{\link{ga_custom_datasource}},
  \code{\link{ga_custom_upload_list}},
  \code{\link{ga_custom_upload}}
}
