% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user-activity.R
\name{ga_clientid_activity}
\alias{ga_clientid_activity}
\title{User Activity Request}
\usage{
ga_clientid_activity(
  ids,
  viewId,
  id_type = c("CLIENT_ID", "USER_ID"),
  activity_type = NULL,
  date_range = NULL
)
}
\arguments{
\item{ids}{The userId or clientId.  You can send in a vector of them}

\item{viewId}{The viewId}

\item{id_type}{Whether its userId or clientId}

\item{activity_type}{If specified, filters down response to the activity type.  Choice between \code{"PAGEVIEW","SCREENVIEW","GOAL","ECOMMERCE","EVENT"}}

\item{date_range}{A vector of start and end dates.  If not used will default to a week.}
}
\value{
A list of data.frames: \code{$sessions} contains session level data. \code{$hits} contains individual activity data
}
\description{
Get activity on an individual user
}
\details{
The User Activity API lets you query an individual user's movement through your website, by sending in the individual `clientId` or `userId`.

Bear in mind each call will count against your API quota, so fetching a large amount of client ids will be limited by that.

Use \link{ga_clientid_activity_unnest} to unnest deeply nested data in the hits data.

The timestamps are available to millisecond level but you will need to set your R options to see them e.g. \code{options(digits.secs=3)}
}
\examples{

\dontrun{

# access data for individual users
uar <- ga_clientid_activity(c("1106980347.1461227730", "476443645.1541099566"),
                         viewId = 81416156, 
                         date_range = c("2019-01-01","2019-02-01"))
                         
# access clientIds for users who have transacted
viewId <- 106249469
date_range <- c("2019-01-01","2019-02-01")
cids <- google_analytics(viewId, 
                         date_range = date_range, 
                         metrics = "sessions", 
                         dimensions = "clientId", 
                         met_filters = filter_clause_ga4(
                           list(met_filter("transactions", 
                                           "GREATER_THAN", 
                                           0)
                                )))
transactors <- ga_clientid_activity(cids$clientId,
                                    viewId = viewId, 
                                    date_range = date_range)

# access the data.frames returned:

# the session level data for the users passed in
uar$sessions

# the hit level activity for the users passed in
uar$hits

# filter the response to only include certain activity types, such as goals:

only_goals <- ga_clientid_activity(c("1106980347.1461227730", 
                                     "476443645.1541099566"),
                     viewId = 81416156, 
                     date_range = c("2019-01-01","2019-02-01"),
                     activity_types = "GOAL") 



}
}
\seealso{
\url{https://developers.google.com/analytics/devguides/reporting/core/v4/rest/v4/userActivity/search}

Other clientid functions: 
\code{\link{ga_clientid_activity_unnest}()},
\code{\link{ga_clientid_deletion}()},
\code{\link{ga_clientid_hash}()}
}
\concept{clientid functions}
