% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generator.R
\name{gar_api_generator}
\alias{gar_api_generator}
\title{googleAuthR data fetch function generator}
\usage{
gar_api_generator(baseURI, http_header = c("GET", "POST", "PUT",
  "DELETE", "PATCH"), path_args = NULL, pars_args = NULL,
  data_parse_function = NULL, customConfig = NULL,
  simplifyVector = getOption("googleAuthR.jsonlite.simplifyVector"),
  checkTrailingSlash = TRUE)
}
\arguments{
\item{baseURI}{The stem of the API call.}

\item{http_header}{Type of http request.}

\item{path_args}{A named list with name=folder in request URI, value=the function variable.}

\item{pars_args}{A named list with name=parameter in request URI, value=the function variable.}

\item{data_parse_function}{A function that takes a request response, parses it and returns the data you need.}

\item{customConfig}{list of httr options such as \link[httr]{use_proxy}
or \link[httr]{add_headers} that will be added to the request.}

\item{simplifyVector}{Passed to \link[jsonlite]{fromJSON} for response parsing}

\item{checkTrailingSlash}{Default TRUE will append a trailing slash to baseURI if missing}
}
\value{
A function that can fetch the Google API data you specify
}
\description{
This function generates other functions for use with Google APIs
}
\details{
\strong{path_args} and \strong{pars_args} add default values to the baseURI.
  NULL entries are removed. Use "" if you want an empty argument.

You don't need to supply access_token for OAuth2 requests in pars_args,
  this is dealt with in gar_auth()

Add custom configurations to the request in this syntax:
 \code{customConfig = list(httr::add_headers("From" = "mark@example.com")}
}
\examples{
\dontrun{
library(googleAuthR)
## change the native googleAuthR scopes to the one needed.
options("googleAuthR.scopes.selected" =
  c("https://www.googleapis.com/auth/urlshortener"))

shorten_url <- function(url){

  body = list(
    longUrl = url
    )

  f <- gar_api_generator("https://www.googleapis.com/urlshortener/v1/url",
                      "POST",
                      data_parse_function = function(x) x$id)

   f(the_body = body)
 }

To use the above functions:
library(googleAuthR)
# go through authentication flow
gar_auth()
s <- shorten_url("http://markedmondson.me")
s
}


}
