% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildtriggers_events.R
\name{GitHubEventsConfig}
\alias{GitHubEventsConfig}
\title{GitHubEventsConfig Object}
\usage{
GitHubEventsConfig(
  x,
  event = c("push", "pull"),
  branch = ".*",
  tag = NULL,
  commentControl = c("COMMENTS_DISABLED", "COMMENTS_ENABLED")
)
}
\arguments{
\item{x}{The repository in format {owner}/{repo} e.g. MarkEdmondson1234/googleCloudRunner}

\item{event}{Whether to trigger on push or pull GitHub events}

\item{branch}{Regex of branches to match}

\item{tag}{If a push request, regexes matching what tags to build. If not \code{NULL} then argument \code{branch} will be ignored}

\item{commentControl}{If a pull request, whether to require comments before builds are triggered.}
}
\value{
GitHubEventsConfig object
}
\description{
GitHubEventsConfig Object
}
\details{
The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at \url{https://github.com/google/re2/wiki/Syntax}
}
\seealso{
Other BuildTrigger functions: 
\code{\link{BuildTrigger}()},
\code{\link{cr_buildtrigger_copy}()},
\code{\link{cr_buildtrigger_delete}()},
\code{\link{cr_buildtrigger_edit}()},
\code{\link{cr_buildtrigger_get}()},
\code{\link{cr_buildtrigger_list}()},
\code{\link{cr_buildtrigger_pubsub}()},
\code{\link{cr_buildtrigger_repo}()},
\code{\link{cr_buildtrigger_run}()},
\code{\link{cr_buildtrigger_webhook}()},
\code{\link{cr_buildtrigger}()}
}
\concept{BuildTrigger functions}
