% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scheduler.R
\name{gce_schedule_docker}
\alias{gce_schedule_docker}
\title{Schedule running a docker image upon a VM}
\usage{
gce_schedule_docker(docker_image, schedule = "53 4 * * *",
  vm = gce_vm_scheduler())
}
\arguments{
\item{docker_image}{the hosted docker image to run on a schedule}

\item{schedule}{The schedule you want to run via cron}

\item{vm}{A VM object to schedule the script upon that you can SSH into}
}
\value{
The crontab schedule of the VM including your script
}
\description{
Utility function to start a VM to run a docker container on a schedule.  
You will need to create and build the Dockerfile first.
}
\details{
You may need to run \link{gce_vm_scheduler} yourself first and then set 
  up SSH details if not defaults, to pass to argument \code{vm}

You can create a Dockerfile with your R script installed by 
  running it through \code{containeRit::dockerfile}.  It also takes care of any dependencies.
  
It is recommended to create a script that is self contained in output and input, 
e.g. don't save files to the VM, instead upload or download any files 
from Google Cloud Storage via authentication via \code{googleAuthR::gar_gce_auth()} 
then downloading and uploading data using \code{library(googleCloudStorageR)} or similar. 

Once the script is working locally, build it and upload to a repository 
  so it can be reached via argument \code{docker_image}

You can build via Google cloud repository build triggers, 
  in which case the name can be created via \link{gce_tag_container}
or build via \link{docker_build} to build on another VM or locally, 
then push to a registry via \link{gce_push_registry}
  
Any Docker image can be run, it does not have to be an R one.
}
\examples{

\dontrun{
# create a Dockerfile of your script
if(!require(containeRit)){
  devtools::install_github("o2r-project/containerit")
  library(containeRit)
}

script <- system.file("schedulescripts", "schedule.R", package = "googleComputeEngineR")

## put the "schedule.R" script in the working directory
file.copy(script, getwd())


## it will run the script whilst making the dockerfile
container <- dockerfile("schedule.R",
                        copy = "script_dir",
                        cmd = CMD_Rscript("schedule.R"),
                        soft = TRUE)
write(container, file = "Dockerfile")

## upload created Dockerfile to GitHub, 
  then use a Build Trigger to create Docker image "demoDockerScheduler"
## built trigger uses "demo-docker-scheduler" as must be lowercase

## After image is built:
## Create a VM to run the schedule
vm <- gce_vm_scheduler("my_scheduler")

## setup any SSH not on defaults
vm <- gce_vm_setup(vm, username = "mark")

## get the name of the just built Docker image that runs your script
docker_tag <- gce_tag_container("demo-docker-scheduler", project = "gcer-public")

## Schedule the docker_tag to run every day at 0453AM
gce_schedule_docker(docker_tag, schedule = "53 4 * * *", vm = vm)


}

}
\seealso{
Other scheduler functions: \code{\link{gce_vm_scheduler}}
}
