% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/version_headers.R
\name{gtm_headers_list}
\alias{gtm_headers_list}
\title{List all container versions of a GTM container}
\usage{
gtm_headers_list(account_id, container_id, includeDeleted = c("TRUE", "FALSE"))
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{includeDeleted}{Include deleted version - Default False}
}
\description{
This will return a data frame all container versions.
If you want to get the information for the most recent version, use \code{gtm_headers_latest}
}
\examples{
\dontrun{

accountId <- 1234567
containerId <- 7654321


headers <- gtm_headers_list(accountId, containerId)

headersWithDeleted <- gtm_headers_list(accountId, containerId, 'TRUE')

}

}
\seealso{
\url{https://developers.google.com/tag-manager/api/v2/reference/accounts/containers/version_headers/list}

Other version header functions: 
\code{\link{gtm_headers_latest}()}
}
\concept{version header functions}
