% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_ls.R
\name{drive_ls}
\alias{drive_ls}
\title{List contents of a folder or Team Drive}
\usage{
drive_ls(path = NULL, ..., recursive = FALSE)
}
\arguments{
\item{path}{Specifies a single folder on Google Drive whose contents you want
to list. Can be an actual path (character), a file id or URL marked with
\code{\link[=as_id]{as_id()}}, or a \code{\link{dribble}}. If it is a Team Drive or is a folder on a Team
Drive, it must be passed as a \code{\link{dribble}}.}

\item{...}{Any parameters that are valid for \code{\link[=drive_find]{drive_find()}}.}

\item{recursive}{Logical, indicating if you want only direct children of
\code{path} (\code{recursive = FALSE}, the default) or all children, including
indirect (\code{recursive = TRUE}).}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per
  item.
}
\description{
List the contents of a folder or Team Drive, recursively or not. This is a
thin wrapper around \code{\link[=drive_find]{drive_find()}}, that simply adds one constraint: the
search is limited to direct or indirect children of \code{path}.
}
\examples{
\dontrun{
## get contents of the folder 'abc' (non-recursive)
drive_ls("abc")

## get contents of folder 'abc' whose names contain the letters 'def'
drive_ls(path = "abc", pattern = "def")

## get all Google spreadsheets in folder 'abc'
## whose names contain the letters 'def'
drive_ls(path = "abc", pattern = "def", type = "spreadsheet")

## get all the files below 'abc', recursively, that are starred
drive_ls(path = "abc", q = "starred = true", recursive = TRUE)
}
}
