% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/permissions.R
\name{gs_perm_delete}
\alias{gs_perm_delete}
\title{Delete a permission from a spreadsheet}
\usage{
gs_perm_delete(ss, email = NULL, perm_id = NULL, verbose = TRUE)
}
\arguments{
\item{ss}{a registered Google spreadsheet, i.e. a \code{\link{googlesheet}}
object}

\item{email}{The email address or domain name for the entity.}

\item{perm_id}{The ID for the permission.}

\item{verbose}{logical; do you want informative messages?}
}
\description{
Identify the permission to be deleted via email or permission ID.
}
\examples{
\dontrun{
foo <- gs_new("foo")
gs_perm_ls(foo)
# Add anyone as a reader:
gs_perm_add(foo, type = "anyone", role = "reader")
gs_perm_ls(foo)
# Remove the permission for anyone
gs_perm_delete(foo, perm_id = "anyoneWithLink")
gs_delete(foo)
}
}
\keyword{internal}

