% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gs_read_cellfeed.R
\name{gs_read_cellfeed}
\alias{gs_read_cellfeed}
\title{Read data from cells}
\usage{
gs_read_cellfeed(ss, ws = 1, range = NULL, return_empty = FALSE,
  return_links = FALSE, verbose = TRUE)
}
\arguments{
\item{ss}{a registered Google spreadsheet, i.e. a \code{\link{googlesheet}}
object}

\item{ws}{positive integer or character string specifying index or title,
respectively, of the worksheet}

\item{range}{a cell range, as described in \code{\link{cell-specification}}}

\item{return_empty}{logical; indicates whether to return empty cells}

\item{return_links}{logical; indicates whether to return the edit and self
links (used internally in cell editing workflow)}

\item{verbose}{logical; do you want informative messages?}
}
\description{
This function consumes data via the "cell feed", which, as the name suggests,
retrieves data cell by cell. Note that the output is a \code{tbl_df} or
\code{data.frame} with \strong{one row per cell}.
}
\details{
Use the \code{range} argument to specify which cells you want to read. See
the examples and the help file for the \link[=cell-specification]{cell
specification functions} for various ways to limit consumption to, e.g., a
rectangle or certain columns. If \code{range} is specified, the associated
cell limits will be checked for internal consistency and compliance with the
known extent of the worksheet. If no limits are provided, all cells will be
returned but consider that \code{\link{gs_read_csv}} and
\code{\link{gs_read_listfeed}} are much faster ways to consume all the data
from a rectangular worksheet.

Empty cells, even if "embedded" in a rectangular region of populated cells,
are not normally returned by the cell feed. This function won't return them
either when \code{return_empty = FALSE} (default), but will if you set
\code{return_empty = TRUE}. If you don't specify any limits AND you set
\code{return_empty = TRUE}, you could be in for a bit of a wait, as the feed
will return all cells, which defaults to 1000 rows and 26 columns.
}
\examples{
\dontrun{
gap_ss <- gs_gap() # register the Gapminder example sheet
first_4_rows <-
  gs_read_cellfeed(gap_ss, "Asia", range = cell_limits(c(NA, 4)))
first_4_rows
gs_reshape_cellfeed(first_4_rows)
gs_reshape_cellfeed(gs_read_cellfeed(gap_ss, "Asia",
                      range = cell_limits(c(NA, 4), c(3, NA))))
}
}
\seealso{
\code{\link{gs_reshape_cellfeed}} or
  \code{\link{gs_simplify_cellfeed}} to perform reshaping or simplification,
  respectively; \code{\link{gs_read}} is a pre-made wrapper that combines
  \code{gs_read_cellfeed} and \code{\link{gs_reshape_cellfeed}}

Other data.consumption.functions: \code{\link{gs_read_csv}};
  \code{\link{gs_read_listfeed}}; \code{\link{gs_read}};
  \code{\link{gs_reshape_cellfeed}};
  \code{\link{gs_simplify_cellfeed}}
}

