% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sheets_cells.R
\name{sheets_cells}
\alias{sheets_cells}
\title{Read cells from a Sheet}
\usage{
sheets_cells(ss, sheet = NULL, range = NULL, skip = 0, n_max = Inf)
}
\arguments{
\item{ss}{Something that identifies a Google Sheet: its file ID, a URL from
which we can recover the ID, or a \code{\link[googledrive:dribble]{dribble}}, which
is how googledrive represents Drive files. Processed through
\code{\link[=as_sheets_id]{as_sheets_id()}}.}

\item{sheet}{Sheet to read, as in "worksheet" or "tab". Either a string (the
name of a sheet), or an integer (the position of the sheet). Ignored if the
sheet is specified via \code{range}. If neither argument specifies the sheet,
defaults to the first visible sheet.}

\item{range}{A cell range to read from. If \code{NULL}, all non-empty cells are
read. Otherwise specify \code{range} as described in \href{https://developers.google.com/sheets/api/guides/concepts#a1_notation}{Sheets A1 notation}
or using the helpers documented in \link{cell-specification}. Sheets uses
fairly standard spreadsheet range notation, although a bit different from
Excel. Examples of valid ranges: \code{"Sheet1!A1:B2"}, \code{"Sheet1!A:A"},
\code{"Sheet1!1:2"}, \code{"Sheet1!A5:A"}, \code{"A1:B2"}, \code{"Sheet1"}. Interpreted
strictly, even if the range forces the inclusion of leading, trailing, or
embedded empty rows or columns. Takes precedence over \code{skip}, \code{n_max} and
\code{sheet}. Note \code{range} can be a named range, like \code{"sales_data"}, without
any cell reference.}

\item{skip}{Minimum number of rows to skip before reading anything, be it
column names or data. Leading empty rows are automatically skipped, so this
is a lower bound. Ignored if \code{range} is given.}

\item{n_max}{Maximum number of data rows to parse into the returned tibble.
Trailing empty rows are automatically skipped, so this is an upper bound on
the number of rows in the result. Ignored if \code{range} is given. \code{n_max} is
imposed locally, after reading all non-empty cells, so, if speed is an
issue, it is better to use \code{range}.}
}
\value{
A tibble with one row per non-empty cell in the \code{range}.
}
\description{
This low-level function returns cell data in a tibble with integer variables
\code{row} and \code{column} (referring to location with the Google Sheet), an A1-style
reference \code{loc}, and a \code{cell} list-column. The flagship function
\code{\link[=read_sheet]{read_sheet()}}, a.k.a. \code{\link[=sheets_read]{sheets_read()}}, is what most users are looking for.
It is basically \code{sheets_cells()} (this function), followed by
\code{\link[=spread_sheet]{spread_sheet()}}, which looks after reshaping and column typing. But if you
want the raw data from the API, use \code{sheets_cells()}.
}
\examples{
if (sheets_has_token()) {
  sheets_cells(sheets_example("deaths"), range = "arts_data")

  sheets_example("cell-contents-and-formats") \%>\%
    sheets_cells(range = "types!A2:A5")
}
}
