% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_reverse_geocode.R
\name{google_reverse_geocode}
\alias{google_reverse_geocode}
\title{Google reverse geocoding}
\usage{
google_reverse_geocode(location, result_type = NULL, location_type = NULL,
  language = NULL, key = get_api_key("reverse_geocode"), simplify = TRUE,
  curl_proxy = NULL)
}
\arguments{
\item{location}{numeric vector of lat/lon coordinates.}

\item{result_type}{string vector - one or more address types.
See \url{https://developers.google.com/maps/documentation/geocoding/intro#Types}
for list of available types.}

\item{location_type}{string vector specifying a location type will restrict the
results to this type. If multiple types are specified, the API will return all
addresses that match any of the types}

\item{language}{string specifies the language in which to return the results.
See the list of supported languages: \url{https://developers.google.com/maps/faq#using-google-maps-apis}.
If no langauge is supplied, the service will attempt to use the language of the
domain from which the request was sent}

\item{key}{string. A valid Google Developers Geocode API key}

\item{simplify}{\code{logical} - TRUE indicates the returned JSON will be
coerced into a list. FALSE indicates the returend JSON will be returned as a string}

\item{curl_proxy}{a curl proxy object}
}
\value{
Either list or JSON string of the geocoded address
}
\description{
Reverse geocoding is the process of converting geographic coordinates into a
human-readable address.
}
\section{API use and limits}{


The amount of queries you can make to Google's APIs is dependent on both the service
and the API you are using.

Each API has specific quotas and limits. Check Google's API documentation for details.

View your usage at the Google Cloud Console \url{https://console.cloud.google.com/}

Each API can only accept and return one request at a time. If you write a loop
to make multiple API calls you should ensure you don't go over your quota / limits
during the loop.
}

\examples{
\dontrun{
## searching for the street address for the rooftop location type
google_reverse_geocode(location = c(-37.81659, 144.9841),
                       result_type = c("street_address"),
                       location_type = "rooftop",
                       key = "<your valid api key>")
}
}
