% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/methods-gpuMatrix.R, R/methods-vclMatrix.R
\docType{methods}
\name{dist,gpuMatrix-method}
\alias{dist,gpuMatrix}
\alias{dist,gpuMatrix-method}
\alias{dist,vclMatrix}
\alias{dist,vclMatrix-method}
\title{GPU Distance Matrix Computations}
\usage{
\S4method{dist}{gpuMatrix}(x, method = "euclidean", diag = FALSE,
  upper = FALSE, p = 2)

\S4method{dist}{vclMatrix}(x, method = "euclidean", diag = FALSE,
  upper = FALSE, p = 2)
}
\arguments{
\item{x}{A gpuMatrix or vclMatrix object}

\item{method}{the distance measure to be used. Only "euclidean" currently
implemented}

\item{diag}{logical value indicating whether the diagonal of the distance
matrix}

\item{upper}{logical value indicating whether the upper triangle of the
distance matrix}

\item{p}{The power of the Minkowski distance (not currently used)}
}
\value{
a gpuMatrix/vclMatrix containing the corresponding distances
}
\description{
This function computes and returns the distance matrix
computed by using the specified distance measure to compute the distances
between the rows of a data matrix.
}

