% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chol.R
\name{chol.vclMatrix}
\alias{chol.vclMatrix}
\alias{chol.gpuMatrix}
\title{Cholesky Decomposition of a gpuR matrix}
\usage{
\method{chol}{vclMatrix}(x, ...)

\method{chol}{gpuMatrix}(x, ...)
}
\arguments{
\item{x}{A symmetric, positive-definite gpuR matrix object.}

\item{...}{arguments to be passed to or from methods}
}
\value{
Default - the upper triangular factor of the Choleski decomposition,
i.e. the matrix \emph{R} such that \emph{R'R} = x.
}
\description{
Compute the Choleski factorization of a real symmetric 
positive-definite square matrix.
}
\note{
This an S3 generic of \link[base]{chol}.  The default continues
to point to the default base function.

No pivoting is used.

The argument \code{upper} is additionally accepted representing a boolean 
which will indicate if the upper or lower (\code{FALSE}) triangle
should be solved.
}
\seealso{
\link[base]{chol}
}
\author{
Charles Determan Jr.
}
