% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_grafify.R
\name{scale_colour_grafify}
\alias{scale_colour_grafify}
\title{\code{scale_colour_} and \code{scale_fill_} functions}
\usage{
scale_colour_grafify(
  palette = "okabe_ito",
  discrete = TRUE,
  ColSeq = TRUE,
  reverse = FALSE,
  ...
)
}
\arguments{
\item{palette}{Name of the \code{grafify} palettes from above, provide within quotes. Default discrete palette is \code{okabe_ito}. For quantitative palette, set \code{discrete = FALSE} (which will apply \code{blue_conti} unless another palette is chosen).}

\item{discrete}{logical TRUE or FALSE. Default is TRUE for discrete colour palettes. Set to FALSE when plotting quantitative data to use quantitative palettes from above.}

\item{ColSeq}{logical TRUE or FALSE. Default TRUE for sequential colours from chosen palette. Set to FALSE for distant colours.}

\item{reverse}{Whether the colour order should be reversed.}

\item{...}{Additional parameters for \code{scale_fill} or \code{scale_colour}.}
}
\value{
ggplot scale_fill function for discrete colours.
}
\description{
These let you apply \code{grafify} discrete or continuous palettes as fill or colour/color aesthetics to any \code{ggplot2} (\code{scale_color_} spelling is also accepted).
}
\details{
The default is \code{palette = "okabe_ito"} and \code{discrete = TRUE}. To apply quantitative colour/fill schemes set \code{discrete = FALSE} (if a palette is not chosen, \code{blue_conti} palette will be applied by default).

Categorical/discreet palettes (only allowed with \code{discrete = TRUE})
\itemize{
\item \code{okabe_ito}
\item \code{bright}
\item \code{contrast}
\item \code{dark}
\item \code{kelly}
\item \code{light}
\item \code{muted}
\item \code{pale}
\item \code{r4}
\item \code{safe}
\item \code{vibrant}
}

By default, sequential colours from above palettes will be chosen. To choose the most distant colours set \code{ColSeq = TRUE}.

Sequential quantitative palettes (only allowed with \code{discrete = FALSE}):
\itemize{
\item \code{grey_conti}
\item \code{blue_conti}
\item \code{yellow_conti}
}

Divergent quantitative palettes (only allowed with \code{discrete = FALSE}):
\itemize{
\item \code{OrBl_div}
\item \code{PrGn_div}
}
}
\examples{
#add a grafify fill scheme to ggplot
ggplot(emmeans::neuralgia, aes(x = Treatment, 
                               y = Duration))+
  geom_boxplot(aes(fill = Treatment), 
               alpha = .6)+
  geom_point(aes(colour = Treatment,
                 shape = Treatment), 
             size = 3)+
  scale_fill_grafify(palette = "bright")+
  scale_colour_grafify(palette = "bright")+
  facet_wrap("Sex")+
  theme_classic()
#distant colours `ColSeq = FALSE`   
ggplot(emmeans::neuralgia, aes(x = Treatment, 
                               y = Duration))+
  geom_boxplot(aes(fill = Treatment), 
               alpha = .6)+
  geom_point(aes(colour = Treatment,
                 shape = Treatment), 
             size = 3)+
  scale_fill_grafify(palette = "bright",
                     ColSeq = FALSE)+
  scale_colour_grafify(palette = "bright",
                       ColSeq = FALSE)+
  facet_wrap("Sex")+
  theme_classic()
#quantiative colour schemes with `discrete = FALSE`
ggplot(mtcars, aes(x = disp,
                   y = mpg))+
  geom_point(aes(colour = cyl), 
             size = 3)+
  scale_colour_grafify(discrete = FALSE)
#quantiative colour scheme
ggplot(mtcars, aes(x = disp,
                   y = mpg))+
  geom_point(aes(colour = cyl), 
             size = 3)+
  scale_colour_grafify(palette = "yellow_conti")
}
