% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_histogram.R
\name{plot_histogram}
\alias{plot_histogram}
\title{Plot data distribution as histograms.}
\usage{
plot_histogram(
  data,
  ycol,
  group,
  facet,
  BinSize = 30,
  c_alpha = 0.2,
  TextXAngle = 0,
  facet_scales = "fixed",
  fontsize = 20,
  linethick,
  Group,
  alpha,
  ColPal = c("okabe_ito", "all_grafify", "bright", "contrast", "dark", "fishy", "kelly",
    "light", "muted", "pale", "r4", "safe", "vibrant"),
  ColSeq = TRUE,
  ColRev = FALSE,
  ...
)
}
\arguments{
\item{data}{a data table e.g. data.frame or tibble.}

\item{ycol}{name of the column containing the quantitative variable whose histogram distribution is to be plotted.}

\item{group}{name of the column containing a categorical grouping variable.}

\item{facet}{add another variable from the data table to create faceted graphs using \code{ggplot2}\link{facet_wrap}.}

\item{BinSize}{bins to use on X-axis, default set to 30.}

\item{c_alpha}{fractional opacity of colour filled within histograms, default set to 0.2 (i.e. 20\% opacity).}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{facet_scales}{whether or not to fix scales on X & Y axes for all facet facet graphs. Can be \code{fixed} (default), \code{free}, \code{free_y} or \code{free_x} (for Y and X axis one at a time, respectively).}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}

\item{linethick}{thickness of symbol border, default set to \code{fontsize}/22.}

\item{Group}{deprecated old argument for \code{group}; retained for backward compatibility.}

\item{alpha}{deprecated old argument for \code{c_alpha}; retained for backward compatibility.}

\item{ColPal}{grafify colour palette to apply, default "okabe_ito"; see \code{\link{graf_palettes}} for available palettes.}

\item{ColSeq}{logical TRUE or FALSE. Default TRUE for sequential colours from chosen palette. Set to FALSE for distant colours, which will be applied using  \code{scale_fill_grafify2}.}

\item{ColRev}{whether to reverse order of colour within the selected palette, default F (FALSE); can be set to T (TRUE).}

\item{...}{any additional arguments to pass to \code{ggplot2}\link{geom_histogram}.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function takes a data table, a quantitative variable (\code{ycol}) and a Grouping variable (\code{group}), if available, and plots a histogram graph using \code{\link{geom_histogram}}).
}
\details{
Note that the function requires the quantitative Y variable first, and groups them based on an X variable. The group variable is mapped to the \code{fill} and \code{colour} aesthetics in \code{geom_histogram}.

ColPal & ColRev options are applied to both \code{fill} and \code{colour} scales. Colours available can be seen quickly with \code{\link{plot_grafify_palette}}.
Colours can be changed using \code{ColPal}, \code{ColRev} or \code{ColSeq} arguments.
\code{ColPal} can be one of the following: "okabe_ito", "dark", "light", "bright", "pale", "vibrant,  "muted" or "contrast".
\code{ColRev} (logical TRUE/FALSE) decides whether colours are chosen from first-to-last or last-to-first from within the chosen palette.
\code{ColSeq} decides whether colours are picked by respecting the order in the palette or the most distant ones using \code{\link[grDevices]{colorRampPalette}}.
}
\examples{
#Basic usage
plot_histogram(data = data_t_pratio, 
ycol = Cytokine, group = Genotype, 
BinSize = 10)
#with log transformation
plot_histogram(data = data_t_pratio, 
ycol = log(Cytokine), group = Genotype, 
BinSize = 10)
}
