% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grandR.R
\name{FindReferences}
\alias{FindReferences}
\title{Obtain reference columns (samples or cells) for all columns (samples or cells) in the data set}
\usage{
FindReferences(
  data,
  reference = NULL,
  reference.function = NULL,
  group = NULL,
  as.list = FALSE,
  columns = NULL
)
}
\arguments{
\item{data}{A grandR object}

\item{reference}{Expression evaluating to a logical vector to indicate which columns are reference columns; evaluated in an environment having the columns of \link{Coldata}(data)}

\item{reference.function}{Function evaluating to a logical vector to indicate which columns are reference columns; called with the data frame row corresponding to the sample, and evaluated in an environment having the columns of \link{Coldata}(data)}

\item{group}{a vector of colnames in \link{Coldata}(data)}

\item{as.list}{return it as a list (names correspond to each sample, elements are the reference samples)}

\item{columns}{find references only for a subset of the columns (samples or cells; can be NULL)}
}
\value{
A logical matrix that contains for each sample or cell (in columns) a TRUE for the corresponding corresponding reference samples or cells in rows
}
\description{
In some situations (see examples) it is required to find a reference sample of some kind for each sample in a data set.
This is a convenience method to find such reference samples, and provide them as a lookup table.
}
\details{
Without any group, the list simply contains all references for each sample/cell. With groups defined, each list entry consists of all references from the same group.

Columns can be given as a logical, integer or character vector representing a selection of the columns (samples or cells).
The expression is evaluated in an environment havin the \code{\link{Coldata}}, i.e. you can use names of \code{\link{Coldata}} as variables to
conveniently build a logical vector (e.g., columns=Condition=="x").
}
\examples{
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c("Condition",Design$dur.4sU,Design$Replicate))
FindReferences(sars,reference=no4sU)
# obtain the corresponding no4sU sample for each sample; use the Condition column
FindReferences(sars,Condition=="Mock",group="duration.4sU.original")
# obtain for each sample the corresponding sample in the Mock condition
FindReferences(sars,Condition=="Mock",group=c("duration.4sU.original","Replicate"))
# obtain for each sample the corresponding Mock sample, paying attention to replicates

}
\seealso{
\link{Coldata},\link{Findno4sUPairs}, \link{Condition}
}
\concept{snapshot}
