% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{PlotGeneProgressiveTimecourse}
\alias{PlotGeneProgressiveTimecourse}
\title{Plot progressive labeling timecourses}
\usage{
PlotGeneProgressiveTimecourse(
  data,
  gene,
  slot = DefaultSlot(data),
  time = Design$dur.4sU,
  type = c("nlls", "ntr", "lm"),
  exact.tics = TRUE,
  show.CI = FALSE,
  return.tables = FALSE,
  ...
)
}
\arguments{
\item{data}{a grandR object}

\item{gene}{the gene to be plotted}

\item{slot}{the data slot of the observed abundances}

\item{time}{the labeling duration column in the column annotation table}

\item{type}{how to fit the model (see link{FitKinetics})}

\item{exact.tics}{use axis labels directly corresponding to the available labeling durations?}

\item{show.CI}{show confidence intervals; one of TRUE/FALSE (default: FALSE)}

\item{return.tables}{also return the tables used for plotting}

\item{...}{given to the fitting procedures}
}
\value{
either a ggplot object, or a list containing all tables used for plotting and the ggplot object.
}
\description{
Plot the abundance of new and old RNA and the fitted model over time for a single gene.
}
\details{
For each \code{\link{Condition}} there will be one panel containing the values and the corresponding model fit.
}
\seealso{
\link{FitKineticsGeneNtr}, \link{FitKineticsGeneLeastSquares}, \link{FitKineticsGeneLogSpaceLinear}
}
\concept{geneplot}
