% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphab_corridor.R
\name{graphab_corridor}
\alias{graphab_corridor}
\title{Computes corridors from least-cost paths already computed in
the Graphab project}
\usage{
graphab_corridor(
  proj_name,
  graph,
  maxcost,
  format = "raster",
  cost_conv = FALSE,
  proj_path = NULL,
  alloc_ram = NULL
)
}
\arguments{
\item{proj_name}{A character string indicating the Graphab project name.
The project name is also the name of the project directory in which the
file proj_name.xml is. It can be created with \code{\link{graphab_project}}}

\item{graph}{A character string indicating the name of the graph with the
links from which the corridors are computed.
This graph has been created with Graphab or using \code{\link{graphab_graph}}
function and is associated with a link set.
Only the links present in the graph will be used in the computation.}

\item{maxcost}{An integer or numeric value indicating the maximum cost
distance from the least-cost paths considered for creating the corridors,
in cost distance units (except when \code{cost_conv = TRUE}).}

\item{format}{(optional, default = "raster") A character string indicating
whether the output is a raster file or a shapefile layer.}

\item{cost_conv}{FALSE (default) or TRUE. Logical indicating whether numeric
\code{thr} values are converted from cost-distance into Euclidean distance
using a log-log linear regression. See also \code{\link{convert_cd}}
function. Only used when \code{mode='neigh'}.}

\item{proj_path}{(optional) A character string indicating the path to the
directory that contains the project directory. It should be used when the
project directory is not in the current working directory. Default is NULL.
When 'proj_path = NULL', the project directory is equal to \code{getwd()}.}

\item{alloc_ram}{(optional, default = NULL) Integer or numeric value
indicating RAM gigabytes allocated to the java process. Increasing this
value can speed up the computations. Too large values may not be compatible
with your machine settings.}
}
\description{
The function computes corridors around the least-cost paths
which have been computed in the Graphab project.
}
\details{
See more information in Graphab 2.8 manual:
\url{https://sourcesup.renater.fr/www/graphab/download/manual-2.8-en.pdf}
Be careful, when capacity has been changed. The last changes are taken into
account for subsequent calculations in a project.
}
\examples{
\dontrun{
graphab_corridor(proj_name = "grphb_ex",
                 graph = "graph",
                 maxcost = 1000,
                 format = "raster",
                 cost_conv = FALSE)
}
}
\author{
P. Savary
}
