% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sequential_PAF.R
\name{plot.SAF_summary}
\alias{plot.SAF_summary}
\title{Produce plots of sequential and average PAF}
\usage{
\method{plot}{SAF_summary}(x, number_rows = 3, max_PAF = 0.4, min_PAF = 0, ...)
}
\arguments{
\item{x}{An SAF_summary R object produced by running the average_paf function.}

\item{number_rows}{integer How many rows of plots will be included on the associated figure.}

\item{max_PAF}{upper limit of y axis on PAF plots (default = 0.4)}

\item{min_PAF}{lower limit of y axis on PAF plots (default = 0)}

\item{...}{Other global arguments inherited by that might be passed to the ggplot routine}
}
\value{
A ggplot2 plotting object illustrating average sequential PAF by position and average PAF by risk factor.
}
\description{
Produce plots of sequential and average PAF
}
\examples{
library(splines)
library(survival)
library(parallel)
options(boot.parallel="snow")
options(boot.ncpus=2)
#  Simulated data on occupational and environmental exposure to
# chronic cough from Eide, 1995
# First specify the causal graph, in terms of the parents of each node.  Then put into a list
parent_urban.rural <- c()
parent_smoking.category <- c("urban.rural")
parent_occupational.exposure <- c("urban.rural")
parent_y <- c("urban.rural","smoking.category","occupational.exposure")
parent_list <- list(parent_urban.rural, parent_smoking.category,
parent_occupational.exposure, parent_y)
# also specify nodes of graph, in order from root to leaves
node_vec <- c("urban.rural","smoking.category","occupational.exposure", "y")
model_list=automatic_fit(Hordaland_data,
parent_list=parent_list, node_vec=node_vec, prev=.09)
out <- average_paf(data=model_list[[length(model_list)]]$data,
 model_list=model_list,
parent_list=parent_list, node_vec=node_vec, prev=.09, nperm=10,
vars = c("urban.rural","occupational.exposure"),ci=FALSE)
plot(out)
\donttest{
# plot with confidence intervals for average and sequential PAF
# (This is probably more useful for more than 2 risk factors).
# Separate axes for each risk factor so confidence intervals can be clearly displayed
out <- average_paf(data=model_list[[length(model_list)]]$data,
 model_list=model_list,
parent_list=parent_list, node_vec=node_vec, prev=.09, nperm=10,
vars = c("urban.rural","occupational.exposure"),ci=TRUE,boot_rep=8)
plot(out)
# Here we plot, with margin of error of point estimate when 50 permutations are used
out <- average_paf(data=model_list[[length(model_list)]]$data,
 model_list=model_list,
parent_list=parent_list, node_vec=node_vec, prev=.09, nperm=50,
vars = c("urban.rural","occupational.exposure"),ci=FALSE,exact=FALSE)
plot(out)
}
}
\references{
Ferguson, J., O’Connell, M. and O’Donnell, M., 2020. Revisiting sequential attributable fractions. Archives of Public Health, 78(1), pp.1-9.
Ferguson, J., Alvarez-Iglesias, A., Newell, J., Hinde, J. and O’Donnell, M., 2018. Estimating average attributable fractions with confidence intervals for cohort and case–control studies. Statistical methods in medical research, 27(4), pp.1141-1152
}
