% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overhaul.R
\name{gt_edges_from_text}
\alias{gt_edges_from_text}
\alias{gt_edges_from_text_}
\title{Edges from text}
\usage{
gt_edges_from_text(data, id, source, tweets, ...)

gt_edges_from_text_(
  data,
  id = "status_id",
  source = "screen_name",
  tweets = "text",
  ...
)
}
\arguments{
\item{data}{Data.frame of tweets, usually returned by the \code{rtweet} package.}

\item{id}{tweets unique id.}

\item{source}{Author of tweets.}

\item{tweets}{Column containing tweets.}

\item{...}{any other column name.}
}
\value{
An object of class \code{graphTweets}.
}
\description{
Get edges from data.frame of tweets.
}
\details{
The \code{tl} arguments stands for \code{\link{tolower}} and allows converting the #hashtags to lower case as 
these often duplicated, i.e.: #python #Python.
}
\section{Functions}{

\itemize{
  \item{\code{gt_edges} - Build networks of users.}
  \item{\code{gt_co_edges} - Build networks of users to hashtags.}
}
}

\examples{
# simulate dataset
tweets <- data.frame(
  text = c("I tweet @you about @him and @her", 
           "I tweet @me about @you"),
  screen_name = c("me", "him"),
  retweet_count = c(19, 5),
  status_id = c(1, 2),
  hashtags = c("rstats", "Python"),
  stringsAsFactors = FALSE
)

tweets \%>\% 
  gt_edges_from_text(status_id, screen_name, text)
    
}
