% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sphereplot.R
\name{sphereplot}
\alias{sphereplot}
\title{Plot a spherical function or point set}
\usage{
sphereplot(
  f,
  n = 100,
  theta0 = pi/2,
  phi0 = 0,
  angle = 0,
  projection = "globe",
  col = gray.colors(256, 0, 1),
  clim = NULL,
  add = FALSE,
  center = c(0, 0),
  radius = 1,
  nv = 500,
  show.border = TRUE,
  show.grid = TRUE,
  grid.phi = seq(0, 330, 30)/180 * pi,
  grid.theta = seq(30, 150, 30)/180 * pi,
  pch = 16,
  pt.col = "black",
  pt.cex = 0.5,
  lwd = 0.5,
  lty = 1,
  line.col = "black",
  background = "white",
  ...
)
}
\arguments{
\item{f}{must be either of:

(1) NULL to plot just grid without spherical function

(2) a vectorized real function f(theta,phi) of the polar angle theta [0,pi] and azimuth angle [0,2pi]

(3) an n-by-2 array of values theta and phi}

\item{n}{number of grid cells in each dimension used in the plot}

\item{theta0}{polar angle in radians at the center of the projection}

\item{phi0}{azimuth angle in radians at the center of the projection}

\item{angle}{angle in radians between vertical axis and central longitudinal great circle}

\item{projection}{type of projection: "globe" (default), "cylindrical", "mollweide"}

\item{col}{color map}

\item{clim}{2-element vector specifying the values of f corresponding to the first and last color in col}

\item{add}{logical flag specifying whether the sphere is to be added to an existing plot}

\item{center}{center of the sphere on the plot}

\item{radius}{radius of the sphere on the plot}

\item{nv}{number or vertices used for grid lines and border}

\item{show.border}{logical flag specifying whether to show a circular border around the sphere}

\item{show.grid}{logical flag specifying whether to show grid lines}

\item{grid.phi}{vector of phi-values of the longitudinal grid lines}

\item{grid.theta}{vector of theta-values of the latitudinal grid lines}

\item{pch}{point type}

\item{pt.col}{point color}

\item{pt.cex}{point size}

\item{lwd}{line width of grid lines and border}

\item{lty}{line type of grid lines and border}

\item{line.col}{color of grid lines and border}

\item{background}{background color}

\item{...}{additional arguments to be passed to the function f}
}
\value{
Returns a list containing the vector \code{col} of colors and 2-vector \code{clim} of values corresponding to the first and last color.
}
\description{
Plots a spherical function or a point set in a 2D projection using only standard R graphics. This avoids compatibility issues of rgl, e.g. knitting markdown documents.
}
\examples{

## Plot random points on the unit sphere in Mollweide projection
set.seed(1)
f = cbind(acos(runif(5000,-1,1)),runif(5000,0,2*pi))
sphereplot(f,theta0=pi/3,projection='mollweide',pt.col='red')

## Plot a spherical function with color bar
nplot(xlim=c(0,1.2), asp=1)
f = function(theta,phi) cos(10*theta+phi)
sp = sphereplot(f, 200, col=planckcolors(200), phi0=0.1, theta0=pi/3,
add=TRUE, center=c(0.5,0.5), radius=0.4, clim=c(-1,1))
colorbar(1,0.1,1.1,0.9,col=sp$col,clim=sp$clim)

}
\author{
Danail Obreschkow
}
