% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yearmonth.R
\name{new_yearmonth}
\alias{new_yearmonth}
\alias{is_yearmonth}
\title{Minimal constructor for a yearmonth object}
\usage{
new_yearmonth(x = integer())

is_yearmonth(xx)
}
\arguments{
\item{x}{\verb{[integer]}

Vector representing the number of months.

\code{double} vectors will be converted via \code{as.integer(floor(x))}.}

\item{xx}{\R object}
}
\value{
A \verb{<grates_yearmonth>} object.
}
\description{
\code{new_yearmonth()} is a constructor for \verb{<grates_yearmonth>} objects aimed at
developers.
}
\details{
\verb{<grates_yearmonth>} objects are stored as the number of months (starting at
0) since the Unix Epoch (1970-01-01). Precision is only to the month level
(i.e. the day of the month is always dropped).
}
\examples{
new_yearmonth(1:10)

}
\references{
The algorithm to convert between dates and months relative to the UNIX Epoch
comes from the work of Davis Vaughan in the unreleased
\href{https://github.com/DavisVaughan/datea/}{datea} package
}
