% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fderiv.R
\name{fderiv}
\alias{fderiv}
\alias{fderiv.gam}
\alias{fderiv.gamm}
\title{First derivatives of fitted GAM functions}
\usage{
fderiv(model, ...)

\method{fderiv}{gam}(model, newdata, term, n = 200, eps = 1e-07,
  unconditional = FALSE, offset = NULL, ...)

\method{fderiv}{gamm}(model, ...)
}
\arguments{
\item{model}{A fitted GAM. Currently only models fitted by \code{\link[mgcv:gam]{mgcv::gam()}} and \code{\link[mgcv:gamm]{mgcv::gamm()}} are supported.}

\item{...}{Arguments that are passed to other methods.}

\item{newdata}{a data frame containing the values of the model covariates at which to evaluate the first derivatives of the smooths.}

\item{term}{character; vector of one or more terms for which derivatives are required. If missing, derivatives for all smooth terms will be returned.}

\item{n}{integer; if \code{newdata} is missing the original data can be reconstructed from \code{model} and then \code{n} controls the number of values over the range of each covariate with which to populate \code{newdata}.}

\item{eps}{numeric; the value of the finite difference used to approximate the first derivative.}

\item{unconditional}{logical; if \code{TRUE}, the smoothing parameter uncertainty corrected covariance matrix is used, \emph{if available}, otherwise the uncorrected Bayesian posterior covariance matrix is used.}

\item{offset}{numeric; value of offset to use in generating predictions.}
}
\value{
An object of class \code{"fderiv"} is returned.
}
\description{
The first derivative of the smooth functions of a GAM model calculated using finite differences.
}
\examples{
library("mgcv")
\dontshow{set.seed(2)}
dat <- gamSim(1, n = 400, dist = "normal", scale = 2)
mod <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat, method = "REML")

## first derivatives of all smooths...
fd <- fderiv(mod)

## ...and a selected smooth
fd2 <- fderiv(mod, term = "x1")

## Models with factors
set.seed(2)
dat <- gamSim(4, n = 400, dist = "normal", scale = 2)
mod <- gam(y ~ s(x0) + s(x1) + fac, data = dat, method = "REML")

## first derivatives of all smooths...
fd <- fderiv(mod)

## ...and a selected smooth
fd2 <- fderiv(mod, term = "x1")
}
\author{
Gavin L. Simpson
}
