% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utililties.R
\name{fix_offset}
\alias{fix_offset}
\title{Fix the names of a data frame containing an offset variable.}
\usage{
fix_offset(model, newdata, offset_val = NULL)
}
\arguments{
\item{model}{a fitted GAM.}

\item{newdata}{data frame; new values at which to predict at.}

\item{offset_val}{numeric, optional; if provided, then the offset variable
in \code{newdata} is set to this constant value before returning \code{newdata}}
}
\value{
The original \code{newdata} is returned with fixed names and possibly
modified offset variable.
}
\description{
Identifies which variable, if any, is the model offset, and fixed the name
such that \code{offset(foo(var))} is converted to \code{var}, and possibly sets the
values of that variable to \code{offset_val}.
}
\examples{
library("mgcv")
\dontshow{set.seed(2)}
df <- gamSim(1, n = 400, dist = "normal")
m <- gam(y ~ s(x0) + s(x1) + offset(x2), data = df, method = "REML")
names(model.frame(m))
names(fix_offset(m, model.frame(m), offset_val = 1L))
}
\author{
Gavin L. Simpson
}
