% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint-methods.R
\name{confint.fderiv}
\alias{confint.fderiv}
\title{Point-wise and simultaneous confidence intervals for derivatives of smooths}
\usage{
\method{confint}{fderiv}(object, parm, level = 0.95,
  type = c("confidence", "simultaneous"), nsim = 10000, ...)
}
\arguments{
\item{object}{an object of class \code{"fderiv"} containing the estimated
derivatives.}

\item{parm}{which parameters (smooth terms) are to be given intervals as a
vector of terms. If missing, all parameters are considered.}

\item{level}{numeric, \code{0 < level < 1}; the confidence level of the
point-wise or simultaneous interval. The default is \code{0.95} for a 95%
interval.}

\item{type}{character; the type of interval to compute. One of \code{"confidence"}
for point-wise intervals, or \code{"simultaneous"} for simultaneous intervals.}

\item{nsim}{integer; the number of simulations used in computing the
simultaneous intervals.}

\item{...}{additional arguments for methods}
}
\value{
a data frame with components:
\enumerate{
\item \code{term}; factor indicating to which term each row relates,
\item \code{lower}; lower limit of the confidence or simultaneous interval,
\item \code{est}; estimated derivative
\item \code{upper}; upper limit of the confidence or simultaneous interval.
}
}
\description{
Calculates point-wise confidence or simultaneous intervals for the first
derivatives of smooth terms in a fitted GAM.
}
\examples{
suppressPackageStartupMessages(library("mgcv"))
\dontshow{
set.seed(2)
op <- options(digits = 5)
}
dat <- gamSim(1, n = 400, dist = "normal", scale = 2)
mod <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat, method = "REML")

## first derivatives of all smooths...
fd <- fderiv(mod)

## point-wise interval
ci <- confint(fd, type = "confidence")
head(ci)

## simultaneous interval for smooth term of x1
set.seed(42)
x1.sint <- confint(fd, parm = "x1", type = "simultaneous", nsim = 1000)
head(x1.sint)
\dontshow{options(op)}
}
\author{
Gavin L. Simpson
}
