% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utililties.R
\name{model_constant}
\alias{model_constant}
\title{Extract the model constant term}
\usage{
model_constant(model)
}
\arguments{
\item{model}{a fitted model for which a \code{coef()} method exists}
}
\description{
Extracts the model constant term, the model intercept, from a fitted model
object.
}
\examples{
\dontshow{
op <- options(digits = 4)
}
load_mgcv()

# simulate a small example
df <- data_sim("eg1", seed = 42)

# fit the GAM
m <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = df, method = "REML")

# extract the estimate of the constant term
model_constant(m)
# same as coef(m)[1L]
coef(m)[1L]

\dontshow{
options(op)
}
}
