# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title IncomeTax
#' @description Calculates the ordinary tax payable given income and tax thresholds and rates.
#' Basic, designed for performance.
#' @name IncomeTax
#' @param x Taxable income.
#' @param thresholds Lower brackets of the tax tables.
#' @param rates Marginal rates
#' @export IncomeTax
NULL

IncomeTax <- function(x, thresholds, rates) {
    .Call(`_grattan_IncomeTax`, x, thresholds, rates)
}

#' @title Medicare levy in C++
#' @description Medicare levy. Experimental function in C++, equivalent to \code{\link{medicare_levy}}.
#' @name MedicareLevy
#' @param income,SpouseIncome,isFamily,NDependants,lowerThreshold,upperThreshold,lowerFamilyThreshold,upperFamilyThreshold,lowerUpForEachChild As in \code{medicare_levy}.
#' @param rate,taper The parameters for the specific year or hypothetical requested.
#' @export MedicareLevy
#' @details For \code{yr > 2018}, the 2017-18 values are used.
NULL

MedicareLevySingle <- function(income, lowerThreshold, upperThreshold, rate = 0.02, taper = 0.1, SpouseIncome = 0, isFamily = FALSE, nDependants = 0L, lowerFamilyThreshold = 46000, upperFamilyThreshold = 54119, lowerUpForEachChild = 3306) {
    .Call(`_grattan_MedicareLevySingle`, income, lowerThreshold, upperThreshold, rate, taper, SpouseIncome, isFamily, nDependants, lowerFamilyThreshold, upperFamilyThreshold, lowerUpForEachChild)
}

MedicareLevySaptoYear <- function(income, SpouseIncome, NDependants, SaptoEligible, yr) {
    .Call(`_grattan_MedicareLevySaptoYear`, income, SpouseIncome, NDependants, SaptoEligible, yr)
}

MedicareLevy <- function(income, lowerThreshold, upperThreshold, SpouseIncome, isFamily, NDependants, lowerFamilyThreshold, upperFamilyThreshold, lowerUpForEachChild, rate, taper) {
    .Call(`_grattan_MedicareLevy`, income, lowerThreshold, upperThreshold, SpouseIncome, isFamily, NDependants, lowerFamilyThreshold, upperFamilyThreshold, lowerUpForEachChild, rate, taper)
}

#' @title General offset in C++
#' @name Offset
#' @description Calculate the offset given a threshold, a maximum offset, and a taper. 
#' @param x A vector of incomes etc.
#' @param y The maximum offset available; the offset when \code{x} is zero.
#' @param a The maximum value of \code{x} at which the maximum offset is available.
#' @param m The taper rate (the \strong{negative} slope).
#' @export Offset
NULL

#' @name MultiOffset
#' @title Multioffset
#' @description An offset with multiple thresholds and tapers.
#' 
#' @param x A numeric vector that the thresholds refer to.
#' @param first_offset \code{numeric(1)} The value of the first offset,
#' the value of the offset for \code{x < first(thresholds)}.
#' @param thresholds The thresholds for changes in the offset.
#' @param tapers The tapers that apply \strong{above} the corresponding element
#' of \code{thresholds}.
#' @param above_zero (bool) Should negative offsets be set to zero?
#' 
#' 
#' @examples
#' MultiOffset(c(36e3, 37e3, 38e3, 47e3, 48e3, 49e3), 
#'             255,
#'             c(37e3, 48e3, 90e3),
#'             c(0.075, 0, -0.03))
#' @noRd
NULL

Offset <- function(x, y, a, m) {
    .Call(`_grattan_Offset`, x, y, a, m)
}

MultiOffset <- function(x, first_offset, thresholds, tapers, above_zero = TRUE) {
    .Call(`_grattan_MultiOffset`, x, first_offset, thresholds, tapers, above_zero)
}

ML_LWR_THR_UP_PER_CHILD <- function(yr) {
    .Call(`_grattan_ML_LWR_THR_UP_PER_CHILD`, yr)
}

ML_LWR_THRESHOLD_SINGLE <- function(yr) {
    .Call(`_grattan_ML_LWR_THRESHOLD_SINGLE`, yr)
}

ML_UPR_THRESHOLD_SINGLE <- function(yr) {
    .Call(`_grattan_ML_UPR_THRESHOLD_SINGLE`, yr)
}

ML_LWR_THRESHOLD_FAMILY <- function(yr) {
    .Call(`_grattan_ML_LWR_THRESHOLD_FAMILY`, yr)
}

ML_UPR_THRESHOLD_FAMILY <- function(yr) {
    .Call(`_grattan_ML_UPR_THRESHOLD_FAMILY`, yr)
}

ML_TAPER <- function(yr) {
    .Call(`_grattan_ML_TAPER`, yr)
}

ML_RATE <- function(yr) {
    .Call(`_grattan_ML_RATE`, yr)
}

LITO_MAX_OFFSET <- function(yr) {
    .Call(`_grattan_LITO_MAX_OFFSET`, yr)
}

LITO_1ST_TAPER <- function(yr) {
    .Call(`_grattan_LITO_1ST_TAPER`, yr)
}

LITO_1ST_THRESH <- function(yr) {
    .Call(`_grattan_LITO_1ST_THRESH`, yr)
}

SAPTO_MAX_SINGLE <- function(yr) {
    .Call(`_grattan_SAPTO_MAX_SINGLE`, yr)
}

SAPTO_MAX_MARRIED <- function(yr) {
    .Call(`_grattan_SAPTO_MAX_MARRIED`, yr)
}

SAPTO_LWR_SINGLE <- function(yr) {
    .Call(`_grattan_SAPTO_LWR_SINGLE`, yr)
}

SAPTO_LWR_MARRIED <- function(yr) {
    .Call(`_grattan_SAPTO_LWR_MARRIED`, yr)
}

SAPTO_TAPER <- function(yr) {
    .Call(`_grattan_SAPTO_TAPER`, yr)
}

ML_LWR_THRESHOLD_SINGLE_SAPTO <- function(yr) {
    .Call(`_grattan_ML_LWR_THRESHOLD_SINGLE_SAPTO`, yr)
}

ML_UPR_THRESHOLD_SINGLE_SAPTO <- function(yr) {
    .Call(`_grattan_ML_UPR_THRESHOLD_SINGLE_SAPTO`, yr)
}

ML_LWR_THRESHOLD_FAMILY_SAPTO <- function(yr) {
    .Call(`_grattan_ML_LWR_THRESHOLD_FAMILY_SAPTO`, yr)
}

ML_UPR_THRESHOLD_FAMILY_SAPTO <- function(yr) {
    .Call(`_grattan_ML_UPR_THRESHOLD_FAMILY_SAPTO`, yr)
}

ML_LWR_THRESHOLD_SINGLE_PTO <- function(yr) {
    .Call(`_grattan_ML_LWR_THRESHOLD_SINGLE_PTO`, yr)
}

ML_LWR_THRESHOLD_FAMILY_PTO <- function(yr) {
    .Call(`_grattan_ML_LWR_THRESHOLD_FAMILY_PTO`, yr)
}

SAPTO_UPR_MARRIED <- function(yr) {
    .Call(`_grattan_SAPTO_UPR_MARRIED`, yr)
}

SAPTO_UPR_SINGLE <- function(yr) {
    .Call(`_grattan_SAPTO_UPR_SINGLE`, yr)
}

SAPTO_MAX_ILL_SEP <- function(yr) {
    .Call(`_grattan_SAPTO_MAX_ILL_SEP`, yr)
}

SAPTO_LWR_ILL_SEP <- function(yr) {
    .Call(`_grattan_SAPTO_LWR_ILL_SEP`, yr)
}

SBTO_DISCOUNT <- function(yr) {
    .Call(`_grattan_SBTO_DISCOUNT`, yr)
}

LITO_2ND_THRESH <- function(yr) {
    .Call(`_grattan_LITO_2ND_THRESH`, yr)
}

LITO_2ND_TAPER <- function(yr) {
    .Call(`_grattan_LITO_2ND_TAPER`, yr)
}

LMITO_1ST_OFFSET <- function(yr) {
    .Call(`_grattan_LMITO_1ST_OFFSET`, yr)
}

LMITO_THRESHS <- function(yr) {
    .Call(`_grattan_LMITO_THRESHS`, yr)
}

LMITO_TAPERS <- function(yr) {
    .Call(`_grattan_LMITO_TAPERS`, yr)
}

ORD_TAX_BRACK <- function(yr) {
    .Call(`_grattan_ORD_TAX_BRACK`, yr)
}

ORD_TAX_RATES <- function(yr) {
    .Call(`_grattan_ORD_TAX_RATES`, yr)
}

LEVY_BRACK <- function(yr) {
    .Call(`_grattan_LEVY_BRACK`, yr)
}

LEVY_RATES <- function(yr) {
    .Call(`_grattan_LEVY_RATES`, yr)
}

#' @name do_income_tax
#' @title Internal function for income tax.
#' @description Accepts a sample file-like List and a tax year and returns
#' a double vector.
#' 
#' @param c_age_30_june Age of taxpayer at 30 June of the financial year.
#' @param is_net_rent Net rent amount.
#' @param it_invest_loss Net financial income loss.
#' @param rebateIncome (NULL, rebate income).
#' @noRd
NULL

do_rN <- function(x, N, max_allowed = 99e6) {
    .Call(`_grattan_do_rN`, x, N, max_allowed)
}

decode_age_range <- function(X, m = 0L) {
    .Call(`_grattan_decode_age_range`, X, m)
}

do_lmito <- function(x) {
    .Call(`_grattan_do_lmito`, x)
}

verify_NA_ALIAS <- function(x = 0L) {
    .Call(`_grattan_verify_NA_ALIAS`, x)
}

do_sapto <- function(x, y, Age, isMarried, max_single = 2230, max_couple = 1602, lwr_single = 32279, lwr_couple = 28974, taper = -0.125, tax_free_thresh = 18200, first_tax_rate = 0.19, second_tax_rate = 0.325, lito_max_offset = 445, lito_1st_thresh = 37e3, lito_1st_taper = -0.015) {
    .Call(`_grattan_do_sapto`, x, y, Age, isMarried, max_single, max_couple, lwr_single, lwr_couple, taper, tax_free_thresh, first_tax_rate, second_tax_rate, lito_max_offset, lito_1st_thresh, lito_1st_taper)
}

sbto_avbl <- function(Total_PP_BE_amt, Total_PP_BI_amt, Total_NPP_BE_amt, Total_NPP_BI_amt) {
    .Call(`_grattan_sbto_avbl`, Total_PP_BE_amt, Total_PP_BI_amt, Total_NPP_BE_amt, Total_NPP_BI_amt)
}

do_medicare_levy <- function(income, spouse_income, is_married, sapto_eligible, n_dependants, sapto_const = FALSE, yr = NA_integer_, lwr_single = 21980L, lwr_family = 37089L, lwr_single_sapto = 34758L, lwr_family_sapto = 48385L, lwr_up_per_child = 2253L, taper = 0.1, rate = 0.02) {
    .Call(`_grattan_do_medicare_levy`, income, spouse_income, is_married, sapto_eligible, n_dependants, sapto_const, yr, lwr_single, lwr_family, lwr_single_sapto, lwr_family_sapto, lwr_up_per_child, taper, rate)
}

do_rebate_income <- function(rebateIncome, ic_taxable_income_loss, it_rept_empl_super_cont, sc_empl_cont, ds_pers_super_cont, it_invest_loss, is_net_rent, it_rept_fringe_benefit, yr) {
    .Call(`_grattan_do_rebate_income`, rebateIncome, ic_taxable_income_loss, it_rept_empl_super_cont, sc_empl_cont, ds_pers_super_cont, it_invest_loss, is_net_rent, it_rept_fringe_benefit, yr)
}

do_income_tax_sf <- function(yr, N, ic_taxable_income_loss, c_age_30_june, rebateIncome, is_net_rent, it_property_loss, it_rept_empl_super_cont, sc_empl_cont, it_rept_fringe_benefit, ds_pers_super_cont, it_invest_loss, spc_rebate_income, isn_sbi_net, is_married, n_dependants) {
    .Call(`_grattan_do_income_tax_sf`, yr, N, ic_taxable_income_loss, c_age_30_june, rebateIncome, is_net_rent, it_property_loss, it_rept_empl_super_cont, sc_empl_cont, it_rept_fringe_benefit, ds_pers_super_cont, it_invest_loss, spc_rebate_income, isn_sbi_net, is_married, n_dependants)
}

do_income_tax2 <- function(ic_taxable_income_loss, yr, c_age_30_june, rebateIncome, is_net_rent, it_property_loss, it_rept_empl_super_cont, sc_empl_cont, it_rept_fringe_benefit, ds_pers_super_cont, it_invest_loss, spc_rebate_income, isn_sbi_net, is_married, n_dependants, ordinary_tax_thresholds, ordinary_tax_rates, temp_levy_brack, temp_levy_rates, offsets, medicare_levy_taper = 0.1, medicare_levy_rate = 0.02, medicare_levy_lower_threshold = 22801, medicare_levy_lower_sapto_threshold = 36056, medicare_levy_lower_family_threshold = 35474, medicare_levy_lower_family_sapto_threshold = 50191, medicare_levy_lower_up_for_each_child = 3533, sapto_max_offset = 2230, sapto_lower_threshold = 32279, sapto_taper = -0.125, sapto_max_offset_married = 1602, sapto_lower_threshold_married = 41790) {
    .Call(`_grattan_do_income_tax2`, ic_taxable_income_loss, yr, c_age_30_june, rebateIncome, is_net_rent, it_property_loss, it_rept_empl_super_cont, sc_empl_cont, it_rept_fringe_benefit, ds_pers_super_cont, it_invest_loss, spc_rebate_income, isn_sbi_net, is_married, n_dependants, ordinary_tax_thresholds, ordinary_tax_rates, temp_levy_brack, temp_levy_rates, offsets, medicare_levy_taper, medicare_levy_rate, medicare_levy_lower_threshold, medicare_levy_lower_sapto_threshold, medicare_levy_lower_family_threshold, medicare_levy_lower_family_sapto_threshold, medicare_levy_lower_up_for_each_child, sapto_max_offset, sapto_lower_threshold, sapto_taper, sapto_max_offset_married, sapto_lower_threshold_married)
}

do_sapto_rcpp <- function(RebateIncome, MaxOffset, LowerThreshold, TaperRate, SaptoEligible, SpouseIncome, IsMarried) {
    .Call(`_grattan_do_sapto_rcpp`, RebateIncome, MaxOffset, LowerThreshold, TaperRate, SaptoEligible, SpouseIncome, IsMarried)
}

do_sapto_rcpp2 <- function(RebateIncome, maxOffsetSingle, maxOffsetMarried, lowerThresholdSingle, lowerThresholdMarried, taperRateSingle, taperRateMarried, SaptoEligible, IsMarried, SpouseIncome) {
    .Call(`_grattan_do_sapto_rcpp2`, RebateIncome, maxOffsetSingle, maxOffsetMarried, lowerThresholdSingle, lowerThresholdMarried, taperRateSingle, taperRateMarried, SaptoEligible, IsMarried, SpouseIncome)
}

#' SAPTO singleton
#' @name sapto_rcpp_singleton
#' @description Length-one version of \code{SAPTO} in C++.
#' @param rebate_income,max_offset,lower_threshold,taper_rate,sapto_eligible,Spouse_income,is_married As in \code{\link{sapto}}.
#' @export
sapto_rcpp_singleton <- function(rebate_income, max_offset, lower_threshold, taper_rate, sapto_eligible, Spouse_income, is_married) {
    .Call(`_grattan_sapto_rcpp_singleton`, rebate_income, max_offset, lower_threshold, taper_rate, sapto_eligible, Spouse_income, is_married)
}

#' @title SAPTO for specific years in C++
#' @name sapto_rcpp_yr
#' @description Fast way to calculate SAPTO for multiple people when the year is known in advance. Speed is by cheating and entering in the year's parameters literally.
#' @param RebateIncome,IsMarried,SpouseIncome As in \code{\link{sapto}}.
#' @export sapto_rcpp_yr
NULL

sapto_rcpp_yr_singleton <- function(rebateIncome, isMarried, spouseIncome, yr) {
    .Call(`_grattan_sapto_rcpp_yr_singleton`, rebateIncome, isMarried, spouseIncome, yr)
}

sapto_rcpp_yr <- function(RebateIncome, SpouseIncome, IsMarried, yr) {
    .Call(`_grattan_sapto_rcpp_yr`, RebateIncome, SpouseIncome, IsMarried, yr)
}

