% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{filter_within_range}
\alias{filter_within_range}
\title{Detect outliers in data using mean and standard deviation}
\usage{
filter_within_range(v, cutoff)
}
\arguments{
\item{v}{A vector with data}

\item{cutoff}{A threshold or cutoff value that defines the range (e.g., 2.5)}
}
\value{
A logical vector of the same length as `v`, where each element is `TRUE` if the corresponding value in `v` falls within the specified range, and `FALSE` otherwise.
}
\description{
Detect outliers using the mean and standard deviation.
}
\examples{
# Sample data
data <- c(10, 12, 14, 15, 20, 25, 30, 100)

# Detect values within 2.5 standard deviations from the mean
filter_within_range(data, cutoff = 2.5)

# Result:
# [1] TRUE TRUE TRUE TRUE TRUE TRUE TRUE TRUE
# Explanation: All values fall within 2.5 standard deviations from the mean.

# Detect values within 1 standard deviation from the mean
filter_within_range(data, cutoff = 1)

# Result:
# [1] TRUE TRUE TRUE TRUE TRUE TRUE TRUE FALSE
# Explanation: All values except 100 fall within 1 standard deviation from the mean.

}
\keyword{internal}
