library(gregmisc)
data(state)
state77 <- as.data.frame(state.x77)
reg  <-  lm(Area ~ Population, data=state77)
ci(reg)
ci(reg, confidence=0.90)
ci(reg, alpha=0.05)
ci(reg, alpha=0.01)

set.seed(12345679,"default")
dat <- rnorm(1000)
ci( dat )
ci( c(NA,dat), na.rm=TRUE )
ci(dat, confidence=0.90)
ci(dat, alpha=0.05)
ci(dat, alpha=0.01)
