% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_flowConnectionInput.R
\name{FlowConnectionMatrix}
\alias{FlowConnectionMatrix}
\title{Object of class \code{FlowConnectionMatrix}}
\usage{
FlowConnectionMatrix(x, g)
}
\arguments{
\item{x}{should be a matrix of ones and zeros, 1 representing flow connectedness between node i and node j.
The matrix should have named rows and columns.
Note that x is symmetric.}

\item{g}{is an igraph object representing the graph. It should have named vertices.}
}
\value{
An object of class \code{FlowConnectionMatrix} containing the matrix of flow connection.
}
\description{
It creates an object of class \code{FlowConnectionMatrix}. Such an object is used as an input to
create subsets based on the criterion of flow connectedness. See Vignette "Subsets and Coordinates".
Within a subset all nodes will be flow connected.
}
\examples{
# create a graph and name the vertices
g<- graph(c(1,2,3,2, 2,4,4,5), directed=TRUE)
g<- set.vertex.attribute(g, "name", V(g), letters[1:5])

# create the flow connection matrix if not available
x<- matrix(rep(1,25), 5, 5)
x[1,3]<- x[3,1]<- 0
colnames(x)<- rownames(x)<- letters[1:5] # columns and rows are named according to the nodes

# create the object of class 'FlowConnectionMatrix'
fcmat<- FlowConnectionMatrix(x,g)
fcmat
rds<- FlowConnect()
sets<- subset(rds, from = fcmat, g)
}
