% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression_tuning.R
\name{tune_regression_forest}
\alias{tune_regression_forest}
\title{Regression forest tuning}
\usage{
tune_regression_forest(X, Y, sample.weights = NULL, num.fit.trees = 10,
  num.fit.reps = 100, num.optimize.reps = 1000, min.node.size = NULL,
  sample.fraction = 0.5, mtry = NULL, alpha = NULL,
  imbalance.penalty = NULL, honesty = TRUE, honesty.fraction = NULL,
  prune.empty.leaves = NULL, clusters = NULL,
  samples.per.cluster = NULL, num.threads = NULL, seed = NULL)
}
\arguments{
\item{X}{The covariates used in the regression.}

\item{Y}{The outcome.}

\item{sample.weights}{(experimental) Weights given to an observation in estimation.
If NULL, each observation is given the same weight. Default is NULL.}

\item{num.fit.trees}{The number of trees in each 'mini forest' used to fit the tuning model. Default is 10.}

\item{num.fit.reps}{The number of forests used to fit the tuning model. Default is 100.}

\item{num.optimize.reps}{The number of random parameter values considered when using the model
to select the optimal parameters. Default is 1000.}

\item{min.node.size}{A target for the minimum number of observations in each tree leaf. Note that nodes
with size smaller than min.node.size can occur, as in the original randomForest package.
Default is 5.}

\item{sample.fraction}{Fraction of the data used to build each tree.
Note: If honesty = TRUE, these subsamples will
further be cut by a factor of honesty.fraction. Default is 0.5.}

\item{mtry}{Number of variables tried for each split. Default is
\eqn{\sqrt p + 20} where p is the number of variables.}

\item{alpha}{A tuning parameter that controls the maximum imbalance of a split. Default is 0.05.}

\item{imbalance.penalty}{A tuning parameter that controls how harshly imbalanced splits are penalized. Default is 0.}

\item{honesty}{Whether or not honest splitting (i.e., sub-sample splitting) should be used. Default is TRUE.}

\item{honesty.fraction}{The fraction of data that will be used for determining splits if honesty = TRUE. Corresponds
to set J1 in the notation of the paper. When using the defaults (honesty = TRUE and
honesty.fraction = NULL), half of the data will be used for determining splits.
Default is 0.5.}

\item{prune.empty.leaves}{(experimental) If true, prunes the estimation sample tree such that no leaves
are empty. If false, keep the same tree as determined in the splits sample (if an empty leave is encountered, that
tree is skipped and does not contribute to the estimate). Setting this to false may improve performance on
small/marginally powered data, but requires more trees. Only applies if honesty is enabled. Default is TRUE.}

\item{clusters}{Vector of integers or factors specifying which cluster each observation corresponds to.
Default is NULL (ignored).}

\item{samples.per.cluster}{If sampling by cluster, the number of observations to be sampled from
each cluster. Must be less than the size of the smallest cluster. If set to NULL
software will set this value to the size of the smallest cluster. Default is NULL.}

\item{num.threads}{Number of threads used in training. By default, the number of threads is set
to the maximum hardware concurrency.}

\item{seed}{The seed of the C++ random number generator.}
}
\value{
A list consisting of the optimal parameter values ('params') along with their debiased
        error ('error').
}
\description{
Finds the optimal parameters to be used in training a regression forest. This method
currently tunes over min.node.size, mtry, sample.fraction, alpha, and imbalance.penalty.
Please see the method 'regression_forest' for a description of the standard forest
parameters. Note that if fixed values can be supplied for any of the parameters mentioned
above, and in that case, that parameter will not be tuned. For example, if this method is
called with min.node.size = 10 and alpha = 0.7, then those parameter values will be treated
as fixed, and only sample.fraction and imbalance.penalty will be tuned.
}
\examples{
\dontrun{
# Find the optimal tuning parameters.
n <- 500
p <- 10
X <- matrix(rnorm(n * p), n, p)
Y <- X[, 1] * rnorm(n)
params <- tune_regression_forest(X, Y)$params

# Use these parameters to train a regression forest.
tuned.forest <- regression_forest(X, Y,
  num.trees = 1000,
  min.node.size = as.numeric(params["min.node.size"]),
  sample.fraction = as.numeric(params["sample.fraction"]),
  mtry = as.numeric(params["mtry"]),
  alpha = as.numeric(params["alpha"]),
  imbalance.penalty = as.numeric(params["imbalance.penalty"])
)
}

}
