% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{willmott}
\alias{willmott}
\title{Willmott Index}
\usage{
willmott(predicted, observed, ...)
}
\arguments{
\item{predicted}{Vector containing the predictions \emph{y}.}

\item{observed}{Vector containing the observations \emph{z}.}

\item{...}{Scaling factor \strong{c} in the denominator in the Willmott index.
The originally proposed value of 2 should be fine.}
}
\value{
willmott Value between -1 and 1
}
\description{
Willmott's index of model performance as described in
Willmott (2012).
}
\details{
This index takes on values from -1 to 1, where values closer to 1 are
generally indicating better model performance. Values close to -1 can
either mean that the model predictions differ strongly from the
observation, or that the observations show small variance (or both).
}
\examples{
predicted = c(21.5, 22.2, 19.1)
observed = c(20, 20, 20)
# The Willmott index "fails" in this case, as the variance in the 
# observation is 0.
willmott(predicted, observed)

# Try with more realistic observations
observed = c(20.5, 19.5, 20.0)
willmott(predicted, observed)

}
\references{
\insertRef{willmott2012RefinedIndexModel}{growR}
}
\seealso{
\code{\link[=get_bias]{get_bias()}}
}
