% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{check_for_package}
\alias{check_for_package}
\title{Check if *package* is available}
\usage{
check_for_package(package, stop = TRUE)
}
\arguments{
\item{package}{Name of the package to check for.}

\item{stop}{Toggle whether an error should be thrown (`TRUE`) or a warning 
generated (`FALSE`).}
}
\value{
`TRUE` if the package was found. `FALSE` if it wasn't found and 
  *stop* is `FALSE`. Otherwise, an error will be thrown.
}
\description{
Some functions not pertaining to the package core require additional 
libraries. These libraries are listed as *suggested* in the `DESCRIPTION` 
When such a function is called by a user who does not have the respective 
libraries installed, we should notice that and notify the user. This is the 
purpose of this *function* `check_for_package`.
}
\details{
The function checks if *package* is installed and loaded. If not, it 
either produces a warning or throws an error, depending on the value of 
*stop*.
}
