% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\docType{methods}
\name{[,multiple_fits,ANY,missing-method}
\alias{[,multiple_fits,ANY,missing-method}
\alias{[[,multiple_fits,ANY,missing-method}
\title{Extract or Replace Parts of a 'multiple_fits' Object}
\usage{
\S4method{[}{multiple_fits,ANY,missing}(x, i, j, ..., drop = TRUE)

\S4method{[[}{multiple_fits,ANY,missing}(x, i, j, ...)
}
\arguments{
\item{x}{object of class multiple_fits}

\item{i}{numeric or character index}

\item{j}{NULL (for compatibility with other uses of  \code{[} or \code{[[})}

\item{drop}{If \code{TRUE} the result is coerced to the lowest possible
dimension}

\item{\dots}{optional arguments passed to \code{[}}
}
\description{
Operators to access parts of 'multiple_fits' objects
}
\examples{

data(bactgrowth)
L <- all_splines(value ~ time | strain + conc +replicate, data=bactgrowth)

coef(L[[1]])

plot(L[["R:0:2"]])

par(mfrow=c(2, 2))
plot(L[1:4])

}

