% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{rsquared,growthrates_fit-method}
\alias{coef,easylinear_fit-method}
\alias{coef,growthrates_fit-method}
\alias{coef,multiple_fits-method}
\alias{coef,smooth.spline_fit-method}
\alias{deviance,growthrates_fit-method}
\alias{deviance,multiple_fits-method}
\alias{deviance,smooth.spline_fit-method}
\alias{df.residual,growthrates_fit-method}
\alias{df.residual,smooth.spline_fit-method}
\alias{obs,growthrates_fit-method}
\alias{residuals,growthrates_fit-method}
\alias{residuals,multiple_fits-method}
\alias{results,multiple_easylinear_fits-method}
\alias{results,multiple_fits-method}
\alias{rsquared,growthrates_fit-method}
\alias{rsquared,multiple_fits-method}
\alias{summary,growthrates_fit-method}
\alias{summary,multiple_fits-method}
\alias{summary,nonlinear_fit-method}
\alias{summary,smooth.spline_fit-method}
\title{Accessor Methods of Package \pkg{growthrates}.}
\usage{
\S4method{rsquared}{growthrates_fit}(object, ...)

\S4method{obs}{growthrates_fit}(object, ...)

\S4method{coef}{growthrates_fit}(object, ...)

\S4method{coef}{easylinear_fit}(object, ...)

\S4method{coef}{smooth.spline_fit}(object, ...)

\S4method{deviance}{growthrates_fit}(object, ...)

\S4method{summary}{growthrates_fit}(object, ...)

\S4method{summary}{nonlinear_fit}(object, cov = TRUE, ...)

\S4method{residuals}{growthrates_fit}(object, ...)

\S4method{df.residual}{growthrates_fit}(object, ...)

\S4method{summary}{smooth.spline_fit}(object, cov = TRUE, ...)

\S4method{df.residual}{smooth.spline_fit}(object, ...)

\S4method{deviance}{smooth.spline_fit}(object, ...)

\S4method{coef}{multiple_fits}(object, ...)

\S4method{rsquared}{multiple_fits}(object, ...)

\S4method{deviance}{multiple_fits}(object, ...)

\S4method{results}{multiple_fits}(object, ...)

\S4method{results}{multiple_easylinear_fits}(object, ...)

\S4method{summary}{multiple_fits}(object, ...)

\S4method{residuals}{multiple_fits}(object, ...)
}
\arguments{
\item{object}{name of a 'growthrate' object.}

\item{cov}{boolean if the covariance matrix should be printed.}

\item{\dots}{other arguments passed to the methods.}
}
\description{
Functions to access the results of fitted growthrate objects:  \code{summary},
 \code{coeff}, \code{rsquared}, \code{deviance}, \code{residuals},
 \code{df.residual}, \code{obs}, \code{results}.
}
\examples{

data(bactgrowth)
splitted.data <- multisplit(bactgrowth, c("strain", "conc", "replicate"))

## get table from single experiment
dat <- splitted.data[[10]]

fit1 <- fit_spline(dat$time, dat$value, spar=0.5)
coef(fit1)
summary(fit1)

## derive start parameters from spline fit
p <- c(coef(fit1), K = max(dat$value))
fit2 <- fit_growthmodel(grow_logistic, p=p, time=dat$time, y=dat$value, transform="log")
coef(fit2)
rsquared(fit2)
deviance(fit2)

summary(fit2)

plot(residuals(fit2) ~ obs(fit2)[,2])


}

