% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/names.R
\docType{methods}
\name{names.growthmodel}
\alias{names,multiple_fits-method}
\alias{names.growthmodel}
\alias{names<-,multiple_fits-method}
\title{Get Names Attributes of Growth Models}
\usage{
\method{names}{growthmodel}(x)

\S4method{names}{multiple_fits}(x)

\S4method{names}{multiple_fits}(x) <- value
}
\arguments{
\item{x}{either a function being a parametric growth model of
package \pkg{growthmodels} or an object with multiple fits.}

\item{value}{a character vector of up to the same length as x, or NULL}
}
\value{
character vector of the parameter names
}
\description{
Methods to get the parameter names of a growth model or to get or set
  identifiers of \code{\link{multiple_fits}} objects.
}
\section{Methods}{

\describe{
  \item{Method for class \code{\link{growthmodel}}:}{ returns information about
  valid parameter names if a \code{pnames} attribute exists, else \code{NULL}.
  \code{NULL}.}
  \item{Method for class \code{\link{multiple_fits}}:}{ can be applied to objects
  returned by \code{all_growthmodels}, \code{all_splines} or
  \code{all_easylinear} respectively. This can be useful for selecting
  subsets, e.g. for plotting, see example below.}
}
}
\examples{

## growthmodel-method
names(grow_baranyi)

## multiple_fits-method
L <- all_splines(value ~ time | strain + conc + replicate,
       data = bactgrowth)

names(L)

## plot only the 'R' strain
par(mfrow=c(4, 6))
plot(L[grep("R:", names(L))])


}
\seealso{
\code{\link{multiple_fits}}, \code{\link{all_growthmodels}},
  \code{\link{all_splines}}, \code{\link{all_easylinear}}
}

