% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_power_combo.R
\name{gs_power_combo}
\alias{gs_power_combo}
\title{Group sequential design power using MaxCombo test under non-proportional hazards}
\usage{
gs_power_combo(
  enroll_rate = define_enroll_rate(duration = 12, rate = 500/12),
  fail_rate = define_fail_rate(duration = c(4, 100), fail_rate = log(2)/15, hr = c(1,
    0.6), dropout_rate = 0.001),
  fh_test = rbind(data.frame(rho = 0, gamma = 0, tau = -1, test = 1, analysis = 1:3,
    analysis_time = c(12, 24, 36)), data.frame(rho = c(0, 0.5), gamma = 0.5, tau = -1,
    test = 2:3, analysis = 3, analysis_time = 36)),
  ratio = 1,
  binding = FALSE,
  upper = gs_b,
  upar = c(3, 2, 1),
  lower = gs_b,
  lpar = c(-1, 0, 1),
  algorithm = mvtnorm::GenzBretz(maxpts = 1e+05, abseps = 1e-05),
  ...
)
}
\arguments{
\item{enroll_rate}{Enrollment rates.}

\item{fail_rate}{Failure and dropout rates.}

\item{fh_test}{A data frame to summarize the test in each analysis.
See examples for its data structure.}

\item{ratio}{Experimental:Control randomization ratio (not yet implemented).}

\item{binding}{Indicator of whether futility bound is binding;
default of \code{FALSE} is recommended.}

\item{upper}{Function to compute upper bound.}

\item{upar}{Parameters passed to \code{upper}.}

\item{lower}{Function to compute lower bound.}

\item{lpar}{Parameters passed to \code{lower}.}

\item{algorithm}{ an object of class \code{\link[mvtnorm]{GenzBretz}},
                    \code{\link[mvtnorm]{Miwa}} or \code{\link[mvtnorm]{TVPACK}}
                    specifying both the algorithm to be used as well as
                    the associated hyper parameters.}

\item{...}{Additional parameters passed to \link[mvtnorm:pmvnorm]{mvtnorm::pmvnorm}.}
}
\value{
A list with input parameters, enrollment rate, analysis, and bound.
}
\description{
Group sequential design power using MaxCombo test under non-proportional hazards
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Validate if lower and upper bounds have been specified.
   \item Extract info, info_fh, theta_fh and corr_fh from utility.
   \item Extract sample size via the maximum sample size of info.
   \item Calculate information fraction either for fixed or group sequential design.
   \item Compute spending function using \code{gs_bound()}.
   \item Compute probability of crossing bounds under the null and alternative
    hypotheses using \code{gs_prob_combo()}.
   \item Export required information for boundary and crossing probability
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
library(dplyr)
library(mvtnorm)
library(gsDesign)
library(gsDesign2)

enroll_rate <- define_enroll_rate(
  duration = 12,
  rate = 500 / 12
)

fail_rate <- define_fail_rate(
  duration = c(4, 100),
  fail_rate = log(2) / 15, # median survival 15 month
  hr = c(1, .6),
  dropout_rate = 0.001
)

fh_test <- rbind(
  data.frame(rho = 0, gamma = 0, tau = -1, test = 1, analysis = 1:3, analysis_time = c(12, 24, 36)),
  data.frame(rho = c(0, 0.5), gamma = 0.5, tau = -1, test = 2:3, analysis = 3, analysis_time = 36)
)

# Example 1 ----
# Minimal Information Fraction derived bound
\donttest{
gs_power_combo(
  enroll_rate = enroll_rate,
  fail_rate = fail_rate,
  fh_test = fh_test,
  upper = gs_spending_combo,
  upar = list(sf = gsDesign::sfLDOF, total_spend = 0.025),
  lower = gs_spending_combo,
  lpar = list(sf = gsDesign::sfLDOF, total_spend = 0.2)
)
}
}
