% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/op_fwer_surv.R
\name{op_fwer_surv}
\alias{op_fwer_surv}
\title{Provides operating characteristics of group sequential MAMS trial for survival outcome under null hypothesis}
\usage{
op_fwer_surv(
  m0,
  alpha,
  beta,
  K,
  frac,
  HR0,
  HR1,
  nsim,
  ta,
  tf,
  kappa,
  eta,
  seed
)
}
\arguments{
\item{m0}{Median survival time in control group.}

\item{alpha}{Type I error.}

\item{beta}{Type II error.}

\item{K}{Number of treatment arms.}

\item{frac}{Vector of fractions for information time at each look.}

\item{HR0}{Hazard ratio of ineffective treatment group vs control.}

\item{HR1}{Hazard ratio of effective treatment group vs control.}

\item{nsim}{Number of simulations.}

\item{ta}{Accrual time.}

\item{tf}{Follow-up time.}

\item{kappa}{Shape parameter (Kappa=1 for exponential distribution).}

\item{eta}{Rate of loss to follow-up.}

\item{seed}{Random seed number.}
}
\value{
A list of FWER, stage-wise type I error, stopping probability, probability of futility, average number of events happened per arm, average duration of trial.
}
\description{
Computes FWER and other characteristics for group-sequential MAMS trial for survival outcome.
}
\examples{
op_fwer_surv(20,0.05,0.1,4,c(1/2,1),1,0.75,12,40,20,1,0,12)  
}
