% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refinedBoundaries.R
\name{genCorrMat}
\alias{genCorrMat}
\title{Correlation Matrix Generator}
\usage{
genCorrMat(gammaVec, type, rhoPS = 0)
}
\arguments{
\item{gammaVec}{a vector which contains gamma_(1), ..., gamma_(K-1), gamma_(K), square root of information vector.}

\item{type}{type of primary or secondary endpoint. For primary endpoint calculation, \code{type} is 1, the returned matrix is K by K. For secondary endpoint calculation, \code{type} is 2, the returned matrix is (K+1) by (K+1).}

\item{rhoPS}{correlation between primary and secondary endpoints.}
}
\value{
correlation matrix, K by K for primary endpoint, (K+1) by (K+1) for secondary endpoint, where K is the number of interims.
}
\description{
Generate correlation matrix between standardized sample mean test statistics for the two endpoint at different looks.
}
\details{
This function generates correlation matrix between different mean statistics. For more details, refer to Tamhane et al. (2017+), section 2.
}
\examples{
corrMat <- genCorrMat(gammaVec=c(sqrt(1/3),sqrt(2/3),1), type=2, rhoPS = 0.3)

}
\references{
Tamhane, A. C., Gou, J., Jennison, C., Mehta, C. R., and Curto, T. (2017+). A gatekeeping procedure to test a primary and a secondary endpoint in a group sequential design with multiple interim looks. \emph{Biometrics}, to appear.
}
\author{
Jiangtao Gou

Fengqing (Zoe) Zhang
}
