% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refinedBoundaries.R
\name{primaryBoundaryVec}
\alias{primaryBoundaryVec}
\title{Calculate the Primary Boundaries}
\usage{
primaryBoundaryVec(alpha, tVec, OBF = TRUE, LanDeMets = FALSE, nRep = 100,
  digits = 2, printOut = TRUE, initIntvl = c(1, 8))
}
\arguments{
\item{alpha}{significance level for the primary endpoint.}

\item{tVec}{information (vector).}

\item{OBF}{type of procedures. \code{TRUE} for OBF, \code{FALSE} for POC.}

\item{LanDeMets}{type of procedures. \code{TRUE} for Lan-Demets type boundaries, \code{FALSE} for original boundaries.}

\item{nRep}{number of replica}

\item{digits}{number of digits for output,}

\item{printOut}{\code{TRUE} for printing the boundaries.}

\item{initIntvl}{parameter for function uniroot (two numbers) for function primaryBoundary or function ldPrimaryBoundary}
}
\value{
OBF and POC boundaries (primary endpoints) (vector).
}
\description{
Primary boundaries are calculated, including the standard approach and the error spending approach.
}
\examples{
#require(mvtnorm)
#K = 4
#alpha = 0.025
#tVec = (1:K)/K
#boundaryVector <- primaryBoundaryVec(alpha,tVec,initIntvl=c(1,4),
#   OBF=TRUE,LanDeMets=FALSE,nRep=1,digits=3,printOut=TRUE)
#boundaryVector <- primaryBoundaryVec(alpha,tVec,initIntvl=c(1,4),
#   OBF=FALSE,LanDeMets=FALSE,nRep=1,digits=3,printOut=TRUE)
#boundaryVector <- primaryBoundaryVec(alpha,tVec,initIntvl=c(1,8),
#   OBF=TRUE,LanDeMets=TRUE,nRep=1,digits=3,printOut=TRUE)
#boundaryVector <- primaryBoundaryVec(alpha,tVec,initIntvl=c(1,4),
#   OBF=FALSE,LanDeMets=TRUE,nRep=1,digits=3,printOut=TRUE)

}
\references{
Jennison, C. and Turnbull, B. W. (2000). \emph{Group Sequential Methods with Applications to Clinical Trials}. Chapman and Hall/CRC, New York.

 Lan, K. K. G., and Demets, D. L. (1983). Discrete sequential boundaries for clinical trials. \emph{Biometrika} \bold{70}, 659-663.

 O'Brien, P. C., and Fleming, T. R. (1979). A multiple testing procedure for clinical trials. \emph{Biometrics} \bold{35}, 549-556.

 Pocock, S. J. (1977). Group sequential methods in the design and analysis of clinical trials. \emph{Biometrika} \bold{64}, 191-199.

 Tamhane, A. C., Gou, J., Jennison, C., Mehta, C. R., and Curto, T. (2017+). A gatekeeping procedure to test a primary and a secondary endpoint in a group sequential design with multiple interim looks. \emph{Biometrics}, to appear.
}
\author{
Jiangtao Gou
}
