% Generated by roxygen2 (4.0.1): do not edit by hand
\name{to_mv_freq}
\alias{to_mv_freq}
\title{Returns mv frequencies for stratum in long format}
\usage{
to_mv_freq(x, stratum = "Population")
}
\arguments{
\item{x}{A \code{data.frame} object with \code{locus} columns}

\item{stratum}{The stratum to use to partition the data (default
"Population")}
}
\value{
A matrix with as many rows as strata and columns as
 alleles across all loci.
}
\description{
This function takes a \code{data.frame} of data and returns
 a matrix of allele frequencies where each row is a stratum
 and each column is an allele frequency (all lumped together).
}
\examples{
AA <- locus( c("A","A") )
  AB <- locus( c("A","B") )
  AC <- locus( c("A","C") )
  BB <- locus( c("B","B") )
  BC <- locus( c("B","C") )
  CC <- locus( c("C","C") )
  loci <- c(AA,AA,AB,AA,BB,BC,CC,BB,BB,CC)
  df <- data.frame( Population=c(rep("A",5),rep("B",5) ), TPI=loci )
  to_mv_freq(df)
}
\author{
Rodney J. Dyer \email{rjdyer@vcu.edu}
}

