% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_Sstar_from_SA}
\alias{gsw_Sstar_from_SA}
\title{Convert from Absolute Salinity to Preformed Salinity}
\usage{
gsw_Sstar_from_SA(SA, p, longitude, latitude)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{p}{sea pressure [ dbar ]}

\item{longitude}{longitude in decimal degrees [ 0 to 360 or -180 to 180]}

\item{latitude}{latitude in decimal degrees [ -90 to 90 ]}
}
\value{
Preformed Salinity [ g/kg ]
}
\description{
Calculate Preformed Salinity from Absolute Salinity, pressure,
longitude, and latitude.
}
\details{
If SA is a matrix and if its dimensions correspond to the
lengths of longitude and latitude, then the latter are
converted to analogous matrices with \code{\link{expand.grid}}.
}
\examples{
gsw_Sstar_from_SA(34.7118, 10, 188, 4) # 34.711575335926490
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_Sstar_from_SA.html}
}
\seealso{
\code{\link{gsw_SA_from_Sstar}} does the reverse; \code{\link{gsw_Sstar_from_SP}} is similar.
}

