% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_Turner_Rsubrho}
\alias{gsw_Turner_Rsubrho}
\title{Turner angle and density ratio}
\usage{
gsw_Turner_Rsubrho(SA, CT, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ deg C ]}

\item{p}{sea pressure [ dbar ]}
}
\value{
list containing Tu [ degrees ], Rsubrho [ unitless ], and p_mid [ dbar ]
}
\description{
This uses the 48-term density equation. The values of Turner Angle
Tu and density ratio Rrho are calculated at mid-point pressures, p_mid.
}
\examples{
SA = c(34.7118, 34.8915)
CT = c(28.8099, 28.4392)
p =  c(     10,      50)
r <- gsw_Turner_Rsubrho(SA, CT, p) # -2.064830032393999, -0.9304018848608, 30
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_Turner_Rsubrho.html}
}

