% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_pot_enthalpy_ice_freezing_poly}
\alias{gsw_pot_enthalpy_ice_freezing_poly}
\title{Potential Enthalpy of Ice at Freezing Point (Polynomial version)}
\usage{
gsw_pot_enthalpy_ice_freezing_poly(SA, p, saturation_fraction = 1)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{saturation_fraction}{fraction of air in water [unitless]}
}
\value{
potential enthalpy [ J/kg ]
}
\description{
Potential Enthalpy of Ice at Freezing Point (Polynomial version)
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
p <- c(      10,      50,     125,     250,     600,    1000)
saturation_fraction = 1
e <- gsw_pot_enthalpy_ice_freezing_poly(SA, p, saturation_fraction)
expect_equal(e/1e5, c(-3.373370858777002, -3.374395733068549, -3.376079507278181,
                    -3.378416106344322, -3.385460970578123, -3.393731732645173))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_pot_enthalpy_ice_freezing_poly.html}
}
\seealso{
Other things related to enthalpy: \code{\link{gsw_CT_from_enthalpy}},
  \code{\link{gsw_dynamic_enthalpy}},
  \code{\link{gsw_enthalpy_CT_exact}},
  \code{\link{gsw_enthalpy_diff}},
  \code{\link{gsw_enthalpy_first_derivatives_CT_exact}},
  \code{\link{gsw_enthalpy_first_derivatives}},
  \code{\link{gsw_enthalpy_ice}},
  \code{\link{gsw_enthalpy_t_exact}},
  \code{\link{gsw_enthalpy}},
  \code{\link{gsw_frazil_properties_potential_poly}},
  \code{\link{gsw_frazil_properties_potential}},
  \code{\link{gsw_pot_enthalpy_from_pt_ice_poly}},
  \code{\link{gsw_pot_enthalpy_from_pt_ice}},
  \code{\link{gsw_pot_enthalpy_ice_freezing}},
  \code{\link{gsw_pt_from_pot_enthalpy_ice_poly}},
  \code{\link{gsw_pt_from_pot_enthalpy_ice}},
  \code{\link{gsw_specvol_first_derivatives_wrt_enthalpy}},
  \code{\link{gsw_specvol_first_derivatives}}
}
