% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_columns.R
\name{cols_move_to_end}
\alias{cols_move_to_end}
\title{Move one or more columns to the end}
\usage{
cols_move_to_end(data, columns)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{columns}{\emph{Columns to target}

\verb{<column-targeting expression>} // \emph{default:} \code{everything()}

The columns for which the moving operations should be applied. Can either
be a series of column names provided in \code{\link[=c]{c()}}, a vector of column indices,
or a select helper function. Examples of select helper functions include
\code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}},
\code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}. The columns move as a group to the
right-most side of the table. The order of the remaining columns will be
preserved.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
It's possible to move a set of columns to the end of the column series, we
only need to specify which \code{columns} are to be moved. While this can be done
upstream of \strong{gt}, this function makes to process much easier and it's less
error prone. The ordering of the \code{columns} that are moved to the end is
preserved (same with the ordering of all other columns in the table).
}
\details{
The columns supplied in \code{columns} must all exist in the table. If you need to
place one or columns at the start of the column series, the
\code{\link[=cols_move_to_start]{cols_move_to_start()}} function should be used. More control is offered with
the \code{\link[=cols_move]{cols_move()}} function, where columns could be placed after a specific
column.
}
\section{Examples}{


For this example, we'll use a portion of the \code{\link{countrypops}} dataset to
create a simple \strong{gt} table. Let's move the \code{year} column, which is the
middle column, to the end of the column series with the
\code{cols_move_to_end()} function.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{countrypops |>
  dplyr::select(-contains("code")) |>
  dplyr::filter(country_name == "Benin") |>
  dplyr::slice_tail(n = 5) |>
  gt() |>
  cols_move_to_end(columns = year)
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_cols_move_to_end_1.png" alt="This image of a table was generated from the first code example in the `cols_move_to_end()` help file." style="width:100\%;">
}}

We can also move multiple columns at a time. With the same
\code{\link{countrypops}}-based table, let's move both the \code{year} and \code{population}
columns to the end of the column series.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{countrypops |>
  dplyr::select(-contains("code")) |>
  dplyr::filter(country_name == "Benin") |>
  dplyr::slice_tail(n = 5) |>
  gt() |>
  cols_move_to_end(columns = c(year, country_name))
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_cols_move_to_end_2.png" alt="This image of a table was generated from the second code example in the `cols_move_to_end()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

5-11
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other column modification functions: 
\code{\link{cols_add}()},
\code{\link{cols_align_decimal}()},
\code{\link{cols_align}()},
\code{\link{cols_hide}()},
\code{\link{cols_label_with}()},
\code{\link{cols_label}()},
\code{\link{cols_merge_n_pct}()},
\code{\link{cols_merge_range}()},
\code{\link{cols_merge_uncert}()},
\code{\link{cols_merge}()},
\code{\link{cols_move_to_start}()},
\code{\link{cols_move}()},
\code{\link{cols_nanoplot}()},
\code{\link{cols_unhide}()},
\code{\link{cols_units}()},
\code{\link{cols_width}()}
}
\concept{column modification functions}
